
package com.prowidesoftware.swift.model.mx.dic;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for POIComponentType6Code.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="POIComponentType6Code"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="AQPP"/&gt;
 *     &lt;enumeration value="APPR"/&gt;
 *     &lt;enumeration value="TLPR"/&gt;
 *     &lt;enumeration value="SCPR"/&gt;
 *     &lt;enumeration value="SERV"/&gt;
 *     &lt;enumeration value="TERM"/&gt;
 *     &lt;enumeration value="DVCE"/&gt;
 *     &lt;enumeration value="SECM"/&gt;
 *     &lt;enumeration value="APLI"/&gt;
 *     &lt;enumeration value="EMVK"/&gt;
 *     &lt;enumeration value="EMVO"/&gt;
 *     &lt;enumeration value="MDWR"/&gt;
 *     &lt;enumeration value="DRVR"/&gt;
 *     &lt;enumeration value="OPST"/&gt;
 *     &lt;enumeration value="MRPR"/&gt;
 *     &lt;enumeration value="CRTF"/&gt;
 *     &lt;enumeration value="TMSP"/&gt;
 *     &lt;enumeration value="SACP"/&gt;
 *     &lt;enumeration value="SAPR"/&gt;
 *     &lt;enumeration value="LOGF"/&gt;
 *     &lt;enumeration value="MDFL"/&gt;
 *     &lt;enumeration value="SOFT"/&gt;
 *     &lt;enumeration value="CONF"/&gt;
 *     &lt;enumeration value="RPFL"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "POIComponentType6Code")
@XmlEnum
public enum POIComponentType6Code {


    /**
     * Parameters for acquirer interface of the point of interaction, including acquirer host configuration parameters.
     * 
     */
    AQPP,

    /**
     * Parameters of a payment application running on the point of interaction.
     * 
     */
    APPR,

    /**
     * Manufacturer configuration parameters of the point of interaction.
     * 
     */
    TLPR,

    /**
     * Security parameters of the point of interaction.
     * 
     */
    SCPR,

    /**
     * Payment server of a point of interaction system.
     * 
     */
    SERV,

    /**
     * Payment terminal point of interaction.
     * 
     */
    TERM,

    /**
     * Device sub-component of a component of the point of interaction.
     * 
     */
    DVCE,

    /**
     * Security module.
     * 
     */
    SECM,

    /**
     * Payment application software.
     * 
     */
    APLI,

    /**
     * EMV application kernel (EMV is the chip card specifications initially defined by Eurocard, Mastercard and Visa).
     * 
     */
    EMVK,

    /**
     * EMV physical interface (EMV is the chip card specifications initially defined by Eurocard, Mastercard and Visa).
     * 
     */
    EMVO,

    /**
     * Software module of the point of interaction.
     * 
     */
    MDWR,

    /**
     * Driver module of the point of interaction.
     * 
     */
    DRVR,

    /**
     * Software that manages hardware to provide common services to the applications.
     * 
     */
    OPST,

    /**
     * Merchant configuration parameters for the point of interaction (POI).
     * 
     */
    MRPR,

    /**
     * Certificate provided by a terminal manager.
     * 
     */
    CRTF,

    /**
     * Configuration parameters for the TMS protocol.
     * 
     */
    TMSP,

    /**
     * Component of the Sale system.
     * 
     */
    SACP,

    /**
     * Parameters related to the Sale to POI protocol.
     * 
     */
    SAPR,

    /**
     * Any repository used for recording log traces.
     * 
     */
    LOGF,

    /**
     * Media file managed by an application of the POI.
     * 
     */
    MDFL,

    /**
     * Payment or other software application.
     * 
     */
    SOFT,

    /**
     * Configuration file relevant for the POI.
     * 
     */
    CONF,

    /**
     * Report file generated by the POI.
     * 
     */
    RPFL;

    public String value() {
        return name();
    }

    public static POIComponentType6Code fromValue(String v) {
        return valueOf(v);
    }

}
