
package com.prowidesoftware.swift.model.mx.dic;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for Side1Code.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="Side1Code">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="BUYI"/>
 *     <enumeration value="SELL"/>
 *     <enumeration value="TWOS"/>
 *     <enumeration value="BUMI"/>
 *     <enumeration value="SEPL"/>
 *     <enumeration value="SESH"/>
 *     <enumeration value="SSEX"/>
 *     <enumeration value="CROS"/>
 *     <enumeration value="CRSH"/>
 *     <enumeration value="CSHE"/>
 *     <enumeration value="DEFI"/>
 *     <enumeration value="OPPO"/>
 *     <enumeration value="UNDI"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "Side1Code")
@XmlEnum
public enum Side1Code {


    /**
     * Order is buy driven.
     * 
     */
    BUYI,

    /**
     * Order is sell driven.
     * 
     */
    SELL,

    /**
     * Indicates that the side refers to both buys and sells.
     * 
     */
    TWOS,

    /**
     * A round-lot market order to buy minus is an order to buy a stated amount of a stock provided that its price is: 
     * - not higher than the last sale if the last sale was a minus or zero minus tick and
     * - not higher than the last sale minus the minimum fractional change in the stock if the last sale was a plus or zero plus tick.
     * A limit price order to buy minus also states the highest price at which it can be executed.
     * 
     */
    BUMI,

    /**
     * A round-lot market order to sell plus is an order to sell a stated amount of a stock provided that its price is: 
     * - not lower than the last sale if the last sale was a plus or zero plus tick and
     * - not lower than the last sale minus the minimum fractional change in the stock if the last sale was a minus or zero minus tick.
     * A limit-price order to sell plus also states the lowest price at which it can be executed.
     * 
     */
    SEPL,

    /**
     * An order to sell a security that the seller does not own; a sale effected by delivering a security borrowed by, or for the account of, the seller. Can only be executed on a plus or zero plus tick.
     * 
     */
    SESH,

    /**
     * Short sale exempt from short-sale rules.
     * 
     */
    SSEX,

    /**
     * Identifies an order for which a broker wishes to take the other side and cross with the client.
     * 
     */
    CROS,

    /**
     * Identifies a type of order for which a broker wants to cross with the client in the case a client wants to establish a short position, and sends a Sell Short order to the broker. Many exchanges have tick rules needing to be enforced, and the order getting converted from Sell Short to Cross (instead of Cross Short) could result in an illegal short sell.
     * 
     */
    CRSH,

    /**
     * Identifies a type of order for which a broker wants to cross with the client in the case a client wants to establish a short position and is exempt from the uptick restriction. Used as audit trail on exchanges.
     * 
     */
    CSHE,

    /**
     * Indicates, in the case of a multileg instrument,that the sides of the legs are the same as defined at the creation of the multileg instrument.
     * 
     */
    DEFI,

    /**
     * Indicates, in the case of a multileg instrument,that the sides of the legs are the opposite of their definition at the creation of the multileg instrument.
     * 
     */
    OPPO,

    /**
     * The side of the indication of interest is not disclosed.
     * 
     */
    UNDI;

    public String value() {
        return name();
    }

    public static Side1Code fromValue(String v) {
        return valueOf(v);
    }

}
