/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.ProwideException;
import com.prowidesoftware.swift.model.DistinguishedName;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.SettlementInfo;
import com.prowidesoftware.swift.model.SettlementMethod;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.model.mx.JaxbContextLoader;
import com.prowidesoftware.swift.model.mx.MxReadParams;
import com.prowidesoftware.swift.model.mx.NamespaceAndElementFilter;
import com.prowidesoftware.swift.model.mx.NamespaceReader;
import com.prowidesoftware.swift.utils.SafeXmlUtils;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.Validate;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class MxParseUtils {
    private static final Logger log = Logger.getLogger(MxParseUtils.class.getName());
    private static final String regex = "^(/|//)([a-zA-Z_][\\w\\-.]*)(/([a-zA-Z_][\\w\\-.]*))*$";
    private static final Pattern pattern = Pattern.compile("^(/|//)([a-zA-Z_][\\w\\-.]*)(/([a-zA-Z_][\\w\\-.]*))*$");

    static SAXSource createFilteredSAXSource(String xml, String localName) {
        XMLReader documentReader = SafeXmlUtils.reader((boolean)true, null);
        NamespaceAndElementFilter documentFilter = new NamespaceAndElementFilter(localName);
        documentFilter.setParent(documentReader);
        InputSource documentInputSource = new InputSource(new StringReader(xml));
        return new SAXSource(documentFilter, documentInputSource);
    }

    static Object parseSAXSource(SAXSource source, Class targetClass, Class<?>[] classes, MxReadParams params) {
        Objects.requireNonNull(targetClass, "target class to parse must not be null");
        Objects.requireNonNull(source, "SAXSource to parse must not be null");
        Objects.requireNonNull(classes, "object model classes array must not be null");
        Objects.requireNonNull(params, "unmarshalling params cannot be null");
        try {
            JAXBElement element;
            JAXBContext context = params.context != null ? params.context : JaxbContextLoader.INSTANCE.get(targetClass, classes);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            if (params.adapters != null) {
                for (XmlAdapter adapter : params.adapters.asList()) {
                    unmarshaller.setAdapter(adapter);
                }
            }
            if ((element = unmarshaller.unmarshal((Source)source, targetClass)) != null) {
                return element.getValue();
            }
        }
        catch (JAXBException | ExecutionException e) {
            MxParseUtils.handleParseException((Exception)e);
        }
        return null;
    }

    static void handleParseException(Exception e) {
        if (e instanceof UnmarshalException) {
            Throwable cause = e.getCause();
            if (cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                throw new ProwideException("Error parsing message at line " + spe.getLineNumber() + ", column " + spe.getColumnNumber(), cause);
            }
            throw new ProwideException("Error parsing message", cause);
        }
        if (e instanceof XMLStreamException) {
            throw new ProwideException("Error parsing message: " + e.getMessage());
        }
        log.log(Level.SEVERE, "An error occurred while reading XML: " + e.getMessage(), e);
    }

    static Object parse(Class targetClass, String xml, Class<?>[] classes, String localName, MxReadParams params) {
        Objects.requireNonNull(targetClass, "target class to parse must not be null");
        Objects.requireNonNull(xml, "XML to parse must not be null");
        Validate.notBlank((CharSequence)xml, (String)"XML to parse must not be a blank string", (Object[])new Object[0]);
        Objects.requireNonNull(classes, "object model classes aray must not be null");
        Validate.notBlank((CharSequence)localName, (String)"The XML element to parse must not be null nor a blank string", (Object[])new Object[0]);
        Objects.requireNonNull(params, "unmarshalling params cannot be null");
        try {
            SAXSource saxSource = MxParseUtils.createFilteredSAXSource(xml, localName);
            return MxParseUtils.parseSAXSource(saxSource, targetClass, classes, params);
        }
        catch (Exception e) {
            MxParseUtils.handleParseException(e);
            return null;
        }
    }

    public static String getBICFromDN(String dn) {
        return DistinguishedName.parseBIC((String)dn);
    }

    public static Optional<MxId> identifyMessage(String xml) {
        Optional<String> namespace = NamespaceReader.findDocumentNamespace(xml);
        if (namespace.isPresent()) {
            return MxParseUtils.enrichBusinessService(namespace.map(MxId::new).orElse(null), xml);
        }
        Optional<String> element = MxParseUtils.findByTags(xml, "MsgDefIdr");
        if (!element.isPresent()) {
            element = MxParseUtils.findByTags(xml, "MsgName");
        }
        if (element.isPresent()) {
            return MxParseUtils.enrichBusinessService(new MxId(element.get()), xml);
        }
        return Optional.empty();
    }

    private static Optional<MxId> enrichBusinessService(MxId mxId, String xml) {
        if (mxId == null) {
            return Optional.empty();
        }
        Optional<String> element = MxParseUtils.findByTags(xml, "BizSvc");
        if (element.isPresent()) {
            mxId.setBusinessService(element.get());
        }
        return Optional.of(mxId);
    }

    public static String makeXmlLenient(String xml) {
        if (xml == null) {
            return null;
        }
        Pattern declPattern = Pattern.compile("(?i)<\\?xml([^>]*)\\?>");
        Matcher declMatcher = declPattern.matcher(xml);
        if (declMatcher.find()) {
            Object attrs = declMatcher.group(1);
            if (!((String)(attrs = ((String)attrs).replaceAll("(?i)(version\\s*=\\s*['\"])(?!1\\.0['\"]|1\\.1['\"])[^'\"]*(['\"])", "$11.0$2"))).matches(".*(?i)version\\s*=\\s*['\"][^'\"]*['\"].*")) {
                attrs = " version=\"1.0\"" + (String)attrs;
            }
            String fixed = "<?xml" + (String)attrs + "?>";
            return declMatcher.replaceFirst(Matcher.quoteReplacement(fixed));
        }
        return xml;
    }

    public static List<String> parseComments(String xml) {
        Objects.requireNonNull(xml, "XML to parse must not be null");
        Validate.notBlank((CharSequence)xml, (String)"XML to parse must not be a blank string", (Object[])new Object[0]);
        ArrayList<String> result = new ArrayList<String>();
        XMLInputFactory factory = SafeXmlUtils.inputFactory();
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(MxParseUtils.makeXmlLenient(xml)));
            while (reader.hasNext()) {
                String comment;
                int event = reader.next();
                if (event != 5 || (comment = reader.getText()) == null) continue;
                result.add(comment.trim());
            }
            reader.close();
        }
        catch (XMLStreamException e) {
            log.log(Level.WARNING, "Error parsing XML comments", e);
        }
        return result;
    }

    public static List<String> parseCommentsStartsWith(String xml, String startWith) {
        return MxParseUtils.parseComments(xml).stream().filter(c -> c.startsWith(startWith)).collect(Collectors.toList());
    }

    public static List<String> parseCommentsContains(String xml, String contains) {
        return MxParseUtils.parseComments(xml).stream().filter(c -> c.contains(contains)).collect(Collectors.toList());
    }

    public static Optional<AbstractMT> parseMtFromMultiformatMessage(String xml) {
        List<String> MTs = MxParseUtils.parseCommentsStartsWith(xml, "{1:F0");
        if (!MTs.isEmpty()) {
            String s = MTs.get(0).replace("^~", "\n");
            try {
                return Optional.of(AbstractMT.parse((String)s));
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Error extracting AbstractMT from Mx", e);
            }
        }
        return Optional.empty();
    }

    public static Optional<SettlementInfo> getSettlementInfo(String xml) {
        Objects.requireNonNull(xml, "XML to parse must not be null");
        Optional<String> sttlmMtdMaybe = MxParseUtils.findByTags(xml, "SttlmMtd");
        Optional<String> clrSysCdMaybe = MxParseUtils.findByTags(xml, "ClrSys", "Cd");
        Optional<String> clrSysPrtryMaybe = MxParseUtils.findByTags(xml, "ClrSys", "Prtry");
        if (sttlmMtdMaybe.isPresent() || clrSysCdMaybe.isPresent() || clrSysPrtryMaybe.isPresent()) {
            SettlementInfo settlementInfo = new SettlementInfo();
            if (sttlmMtdMaybe.isPresent()) {
                settlementInfo.setSettlementMethod((SettlementMethod)EnumUtils.getEnum(SettlementMethod.class, (String)sttlmMtdMaybe.get()));
            }
            if (clrSysCdMaybe.isPresent()) {
                settlementInfo.setClearingSystemCode(clrSysCdMaybe.get());
            } else if (clrSysPrtryMaybe.isPresent()) {
                settlementInfo.setClearingSystemCode(clrSysPrtryMaybe.get());
            }
            return Optional.of(settlementInfo);
        }
        return Optional.empty();
    }

    /*
     * Exception decompiling
     */
    public static Optional<String> findByTags(String xml, String ... tags) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public static Optional<XMLStreamReader> findElementByTags(String xml, String ... tags) {
        Objects.requireNonNull(xml, "XML to parse must not be null");
        Validate.notBlank((CharSequence)xml, (String)"XML to parse must not be a blank string", (Object[])new Object[0]);
        Objects.requireNonNull(tags, "tags to find must not be null");
        XMLInputFactory xif = SafeXmlUtils.inputFactory();
        int tagsIndex = 0;
        try {
            XMLStreamReader reader = xif.createXMLStreamReader(new StringReader(MxParseUtils.makeXmlLenient(xml)));
            while (reader.hasNext()) {
                int event = reader.next();
                if (1 != event || !reader.getLocalName().equals(tags[tagsIndex])) continue;
                if (tagsIndex == tags.length - 1) {
                    return Optional.of(reader);
                }
                ++tagsIndex;
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Error reading XML", e);
        }
        return Optional.empty();
    }

    /*
     * Exception decompiling
     */
    public static Optional<String> findByPath(String xml, String targetPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CASE], 13[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    public static Optional<XMLStreamReader> findElementByPath(String xml, String targetPath) {
        Objects.requireNonNull(xml, "XML to parse must not be null");
        Validate.notBlank((CharSequence)xml, (String)"XML to parse must not be a blank string", (Object[])new Object[0]);
        Objects.requireNonNull(targetPath, "targetPath to find must not be null");
        Validate.notBlank((CharSequence)targetPath, (String)"targetPath must not be a blank string", (Object[])new Object[0]);
        Matcher matcher = pattern.matcher(targetPath);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid path format: " + targetPath);
        }
        boolean isRelative = targetPath.startsWith("//");
        if (isRelative) {
            targetPath = targetPath.substring(1);
        }
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(xml));
            Stack<String> pathStack = new Stack<String>();
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        if (!reader.getLocalName().equals("RequestPayload")) {
                            pathStack.push(reader.getLocalName());
                            String currentPath = MxParseUtils.buildCurrentPath(pathStack);
                            if (!currentPath.equals(targetPath) && !currentPath.contains(targetPath)) break;
                            return Optional.of(reader);
                        }
                    }
                    case 2: {
                        if (pathStack.isEmpty()) break;
                        pathStack.pop();
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Error finding element by path", e);
        }
        return Optional.empty();
    }

    private static String buildCurrentPath(Stack<String> pathStack) {
        return "/" + String.join((CharSequence)"/", pathStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean elementExists(String xml, String localName) {
        Objects.requireNonNull(xml, "XML to parse must not be null");
        Validate.notBlank((CharSequence)xml, (String)"XML to parse must not be a blank string", (Object[])new Object[0]);
        Objects.requireNonNull(localName, "Element name to find must not be null");
        Validate.notBlank((CharSequence)localName, (String)"Element name must not be a blank string", (Object[])new Object[0]);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = null;
        try {
            reader = factory.createXMLStreamReader(new StringReader(xml));
            while (reader.hasNext()) {
                int event = reader.next();
                if (event != 1 || !reader.getLocalName().equals(localName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.SEVERE, "Error reading XML", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    log.log(Level.WARNING, "Error closing XMLStreamReader", e);
                }
            }
        }
        return false;
    }
}

