/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.EscapeHandler;
import com.prowidesoftware.swift.model.mx.MxParseUtils;
import com.prowidesoftware.swift.model.mx.MxReadParams;
import com.prowidesoftware.swift.model.mx.MxWriteParams;
import com.prowidesoftware.swift.model.mx.MxWriteUtils;
import com.prowidesoftware.swift.model.mx.XmlEventWriter;
import com.prowidesoftware.swift.model.mx.dic.BusinessApplicationHeaderV04Impl;
import com.prowidesoftware.swift.model.mx.dic.Party51Choice;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.StringWriter;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AppHdr")
@XmlRootElement(name="AppHdr", namespace="urn:iso:std:iso:20022:tech:xsd:head.001.001.04")
public class BusinessAppHdrV04
extends BusinessApplicationHeaderV04Impl
implements AppHdr {
    public static final String NAMESPACE = "urn:iso:std:iso:20022:tech:xsd:head.001.001.04";
    static final Class[] _classes;
    private static final Logger log;

    public static BusinessAppHdrV04 parse(String xml) {
        return BusinessAppHdrV04.parse(xml, new MxReadParams());
    }

    public static BusinessAppHdrV04 parse(String xml, MxReadParams params) {
        Objects.requireNonNull(params, "The unmarshalling params cannot be null");
        return (BusinessAppHdrV04)MxParseUtils.parse(BusinessAppHdrV04.class, xml, _classes, "AppHdr", params);
    }

    Class[] getClasses() {
        return _classes;
    }

    @Override
    public String from() {
        return this.getBIC(this.getFr());
    }

    @Override
    public String to() {
        return this.getBIC(this.getTo());
    }

    private String getBIC(Party51Choice p) {
        try {
            String found = p.getFIId().getFinInstnId().getBICFI();
            if (!StringUtils.isEmpty((CharSequence)found)) {
                return found;
            }
        }
        catch (NullPointerException e) {
            try {
                String found = p.getOrgId().getId().getOrgId().getAnyBIC();
                if (!StringUtils.isEmpty((CharSequence)found)) {
                    return found;
                }
            }
            catch (NullPointerException e2) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String reference() {
        return this.getBizMsgIdr();
    }

    @Override
    public String messageName() {
        return this.getMsgDefIdr();
    }

    @Override
    public String serviceName() {
        return this.getBizSvc();
    }

    @Override
    public boolean duplicate() {
        return this.isPssblDplct() != null && this.isPssblDplct() != false;
    }

    @Override
    public OffsetDateTime creationDate() {
        return this.getCreDt();
    }

    @Override
    public void setCreationDate(boolean overwrite) {
        if (this.getCreDt() == null || overwrite) {
            this.setCreDt(OffsetDateTime.now(ZoneOffset.UTC));
        }
    }

    @Override
    @Deprecated
    public String xml(String prefix, boolean includeXMLDeclaration) {
        DeprecationUtils.phase3(AbstractMX.class, (String)"xml(String, boolean)", (String)"Use xml(MxWriteParams) instead");
        MxWriteParams params = new MxWriteParams();
        params.prefix = prefix;
        params.includeXMLDeclaration = includeXMLDeclaration;
        return this.xml(params);
    }

    @Override
    @Deprecated
    public String xml(String prefix, boolean includeXMLDeclaration, EscapeHandler escapeHandler) {
        DeprecationUtils.phase3(AbstractMX.class, (String)"xml(String, boolean, EscapeHandler)", (String)"Use xml(MxWriteParams) instead");
        MxWriteParams params = new MxWriteParams();
        params.prefix = prefix;
        params.includeXMLDeclaration = includeXMLDeclaration;
        params.escapeHandler = escapeHandler;
        return this.xml(params);
    }

    @Override
    public String xml(MxWriteParams params) {
        try {
            JAXBContext context = params.context != null ? params.context : JAXBContext.newInstance((Class[])new Class[]{BusinessApplicationHeaderV04Impl.class});
            Marshaller marshaller = MxWriteUtils.createMarshaller(context, params);
            StringWriter sw = new StringWriter();
            JAXBElement element = new JAXBElement(new QName(NAMESPACE, "AppHdr"), BusinessApplicationHeaderV04Impl.class, null, (Object)this);
            XmlEventWriter eventWriter = new XmlEventWriter(sw, params.prefix, params.includeXMLDeclaration, "AppHdr", params.escapeHandler, params.indent);
            marshaller.marshal((Object)element, (XMLEventWriter)eventWriter);
            return sw.getBuffer().toString();
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, "Error writing head.001.001.04 XML:" + e.getMessage());
            return null;
        }
    }

    @Override
    public Element element() {
        return this.element(null);
    }

    public Element element(JAXBContext inputContext) {
        try {
            JAXBContext context = inputContext != null ? inputContext : JAXBContext.newInstance((Class[])new Class[]{BusinessApplicationHeaderV04Impl.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            DOMResult res = new DOMResult();
            JAXBElement element = new JAXBElement(new QName(NAMESPACE, "AppHdr"), BusinessApplicationHeaderV04Impl.class, null, (Object)this);
            marshaller.marshal((Object)element, (Result)res);
            Document doc = (Document)res.getNode();
            return (Element)doc.getFirstChild();
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, "Error writing head.001.001.04 XML:" + e.getMessage());
            return null;
        }
    }

    @Override
    public String namespace() {
        return NAMESPACE;
    }

    static {
        log = Logger.getLogger(BusinessAppHdrV04.class.getName());
        _classes = Arrays.copyOf(BusinessApplicationHeaderV04Impl._classes, BusinessApplicationHeaderV04Impl._classes.length + 1);
        BusinessAppHdrV04._classes[BusinessAppHdrV04._classes.length - 1] = BusinessAppHdrV04.class;
    }
}

