
package com.prowidesoftware.swift.model.mx.dic;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for AddressType2Code.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="AddressType2Code"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="ADDR"/&gt;
 *     &lt;enumeration value="PBOX"/&gt;
 *     &lt;enumeration value="HOME"/&gt;
 *     &lt;enumeration value="BIZZ"/&gt;
 *     &lt;enumeration value="MLTO"/&gt;
 *     &lt;enumeration value="DLVY"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "AddressType2Code")
@XmlEnum
public enum AddressType2Code {


    /**
     * Address is the complete postal address.
     * 
     */
    ADDR,

    /**
     * Address is a postal office (PO) box.
     * 
     */
    PBOX,

    /**
     * Address is the home address.
     * 
     */
    HOME,

    /**
     * Address is the business address.
     * 
     */
    BIZZ,

    /**
     * Address is the address to which mail is sent.
     * 
     */
    MLTO,

    /**
     * Address is the address to which delivery is to take place.
     * 
     */
    DLVY;

    public String value() {
        return name();
    }

    public static AddressType2Code fromValue(String v) {
        return valueOf(v);
    }

}
