
package com.prowidesoftware.swift.model.mx.dic;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * Provides the details for one to many netting cut off update requests to be actioned by a central system.
 * 
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "NettingCutOff2", propOrder = {
    "netgId",
    "newCutOff"
})
public class NettingCutOff2 {

    @XmlElement(name = "NetgId", required = true)
    protected NettingIdentification2Choice netgId;
    @XmlElement(name = "NewCutOff", required = true)
    protected List<CutOff1> newCutOff;

    /**
     * Gets the value of the netgId property.
     * 
     * @return
     *     possible object is
     *     {@link NettingIdentification2Choice }
     *     
     */
    public NettingIdentification2Choice getNetgId() {
        return netgId;
    }

    /**
     * Sets the value of the netgId property.
     * 
     * @param value
     *     allowed object is
     *     {@link NettingIdentification2Choice }
     *     
     */
    public NettingCutOff2 setNetgId(NettingIdentification2Choice value) {
        this.netgId = value;
        return this;
    }

    /**
     * Gets the value of the newCutOff property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the newCutOff property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNewCutOff().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CutOff1 }
     * 
     * 
     */
    public List<CutOff1> getNewCutOff() {
        if (newCutOff == null) {
            newCutOff = new ArrayList<CutOff1>();
        }
        return this.newCutOff;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    /**
     * Adds a new item to the newCutOff list.
     * @see #getNewCutOff()
     * 
     */
    public NettingCutOff2 addNewCutOff(CutOff1 newCutOff) {
        getNewCutOff().add(newCutOff);
        return this;
    }

}
