/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import com.prowidesoftware.swift.model.mx.adapters.AdapterUtils;
import java.text.SimpleDateFormat;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.XMLGregorianCalendar;

public class ZuluDateTimeAdapter
extends XmlAdapter<String, XMLGregorianCalendar> {
    private final SimpleDateFormat marshalFormat;
    private final SimpleDateFormat unmarshalFormat;
    private final XmlAdapter<String, XMLGregorianCalendar> customAdapterImpl;

    public ZuluDateTimeAdapter() {
        this.marshalFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.unmarshalFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss[.SSS]['Z']");
        this.customAdapterImpl = null;
    }

    public ZuluDateTimeAdapter(SimpleDateFormat dateFormat) {
        this.marshalFormat = dateFormat;
        this.unmarshalFormat = dateFormat;
        this.customAdapterImpl = null;
    }

    public ZuluDateTimeAdapter(XmlAdapter<String, XMLGregorianCalendar> customAdapterImpl) {
        this.marshalFormat = null;
        this.unmarshalFormat = null;
        this.customAdapterImpl = customAdapterImpl;
    }

    public XMLGregorianCalendar unmarshal(String value) throws Exception {
        if (this.customAdapterImpl != null) {
            return (XMLGregorianCalendar)this.customAdapterImpl.unmarshal((Object)value);
        }
        return AdapterUtils.parse(this.unmarshalFormat, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String marshal(XMLGregorianCalendar cal) throws Exception {
        String formatted;
        if (this.customAdapterImpl != null) {
            return (String)this.customAdapterImpl.marshal((Object)cal);
        }
        SimpleDateFormat simpleDateFormat = this.marshalFormat;
        synchronized (simpleDateFormat) {
            formatted = AdapterUtils.format(this.marshalFormat, cal);
        }
        return formatted.replace(".000", "");
    }
}

