/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.ProwideException;
import com.prowidesoftware.swift.model.DistinguishedName;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.mx.JaxbContextLoader;
import com.prowidesoftware.swift.model.mx.MxReadParams;
import com.prowidesoftware.swift.model.mx.NamespaceAndElementFilter;
import com.prowidesoftware.swift.model.mx.NamespaceReader;
import com.prowidesoftware.swift.utils.SafeXmlUtils;
import java.io.StringReader;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.lang3.Validate;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class MxParseUtils {
    private static final transient Logger log = Logger.getLogger(MxParseUtils.class.getName());

    static SAXSource createFilteredSAXSource(String xml, String localName) {
        XMLReader documentReader = SafeXmlUtils.reader((boolean)true, null);
        NamespaceAndElementFilter documentFilter = new NamespaceAndElementFilter(localName);
        documentFilter.setParent(documentReader);
        InputSource documentInputSource = new InputSource(new StringReader(xml));
        return new SAXSource(documentFilter, documentInputSource);
    }

    static Object parseSAXSource(SAXSource source, Class targetClass, Class<?>[] classes, MxReadParams params) {
        Objects.requireNonNull(targetClass, "target class to parse must not be null");
        Objects.requireNonNull(source, "SAXSource to parse must not be null");
        Objects.requireNonNull(classes, "object model classes array must not be null");
        Objects.requireNonNull(params, "unmarshalling params cannot be null");
        try {
            JAXBElement element;
            JAXBContext context = params.context != null ? params.context : JaxbContextLoader.INSTANCE.get(targetClass, classes);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            if (params.adapters != null) {
                for (XmlAdapter adapter : params.adapters.asList()) {
                    unmarshaller.setAdapter(adapter);
                }
            }
            if ((element = unmarshaller.unmarshal((Source)source, targetClass)) != null) {
                return element.getValue();
            }
        }
        catch (ExecutionException | JAXBException e) {
            MxParseUtils.handleParseException((Exception)e);
        }
        return null;
    }

    static void handleParseException(Exception e) {
        if (e instanceof UnmarshalException) {
            Throwable cause = e.getCause();
            if (cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                throw new ProwideException("Error parsing message at line " + spe.getLineNumber() + ", column " + spe.getColumnNumber(), cause);
            }
            throw new ProwideException("Error parsing message", cause);
        }
        if (e instanceof XMLStreamException) {
            throw new ProwideException("Error parsing message: " + e.getMessage());
        }
        log.severe("An error occurred while reading XML: " + e.getMessage());
        e.printStackTrace();
    }

    static Object parse(Class targetClass, String xml, Class<?>[] classes, String localName, MxReadParams params) {
        Objects.requireNonNull(targetClass, "target class to parse must not be null");
        Objects.requireNonNull(xml, "XML to parse must not be null");
        Validate.notBlank((CharSequence)xml, (String)"XML to parse must not be a blank string", (Object[])new Object[0]);
        Objects.requireNonNull(classes, "object model classes aray must not be null");
        Validate.notBlank((CharSequence)localName, (String)"The XML element to parse must not be null nor a blank string", (Object[])new Object[0]);
        Objects.requireNonNull(params, "unmarshalling params cannot be null");
        try {
            SAXSource saxSource = MxParseUtils.createFilteredSAXSource(xml, localName);
            return MxParseUtils.parseSAXSource(saxSource, targetClass, classes, params);
        }
        catch (Exception e) {
            MxParseUtils.handleParseException(e);
            return null;
        }
    }

    public static String getBICFromDN(String dn) {
        return DistinguishedName.parseBIC((String)dn);
    }

    public static Optional<MxId> identifyMessage(String xml) {
        Optional<String> namespace = NamespaceReader.findDocumentNamespace(xml);
        if (namespace.isPresent()) {
            return MxParseUtils.enrichBusinessService(namespace.map(MxId::new).orElse(null), xml);
        }
        Optional<XMLStreamReader> element = NamespaceReader.findElement(xml, "MsgDefIdr");
        if (!element.isPresent()) {
            element = NamespaceReader.findElement(xml, "MsgName");
        }
        if (element.isPresent()) {
            try {
                return MxParseUtils.enrichBusinessService(new MxId(element.get().getElementText()), xml);
            }
            catch (XMLStreamException e) {
                log.finer("Error identifying message: " + e.getMessage());
            }
        }
        return Optional.empty();
    }

    private static Optional<MxId> enrichBusinessService(MxId mxId, String xml) {
        if (mxId == null) {
            return Optional.empty();
        }
        Optional<XMLStreamReader> element = NamespaceReader.findElement(xml, "BizSvc");
        if (element.isPresent()) {
            try {
                mxId.setBusinessService(element.get().getElementText());
            }
            catch (XMLStreamException e) {
                log.finer("Error identifying business service: " + e.getMessage());
            }
        }
        return Optional.of(mxId);
    }

    public static String makeXmlLenient(String xml) {
        return xml != null ? xml.replaceFirst("(?i)<\\?XML", "<?xml") : null;
    }
}

