/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.MxNodeContentHandler;
import com.prowidesoftware.swift.utils.SafeXmlUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class MxNode {
    public static final transient String PATH_SEPARATOR = "/";
    private static final transient Logger log = Logger.getLogger(MxNode.class.getName());
    private final List<MxNode> children = new ArrayList<MxNode>();
    private MxNode parent = null;
    private String value = null;
    private String localName;
    private Map<String, String> attributes = null;

    public MxNode() {
    }

    public MxNode(MxNode parent, String localName) {
        this();
        this.localName = localName;
        if (parent != null) {
            this.parent = parent;
            parent.addChild(this);
        }
    }

    public static MxNode parse(String xml) {
        Objects.requireNonNull(xml, "the XML to parser cannot be null");
        Validate.notBlank((CharSequence)xml, (String)"the XML to parser cannot be blank", (Object[])new Object[0]);
        try {
            XMLReader xmlReader = SafeXmlUtils.reader((boolean)true, null);
            MxNodeContentHandler contentHandler = new MxNodeContentHandler();
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(new InputSource(new StringReader(xml)));
            return contentHandler.getRootNode();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error parsing XML", e);
            return null;
        }
    }

    private static MxNode _getRoot(MxNode mxNode) {
        if (mxNode == null) {
            return null;
        }
        return mxNode.parent == null ? mxNode : MxNode._getRoot(mxNode.parent);
    }

    private void addChild(MxNode child) {
        this.children.add(child);
    }

    public String singlePathValue(String path) {
        MxNode first = this.findFirst(path);
        if (first != null) {
            return first.getValue();
        }
        return null;
    }

    public MxNode findFirst(String path) {
        List<MxNode> found = this.find(path);
        if (!found.isEmpty()) {
            return found.get(0);
        }
        return null;
    }

    public List<MxNode> find(String path) {
        String[] segments = StringUtils.split((String)path, (String)PATH_SEPARATOR);
        MxNode start = path != null && path.startsWith(PATH_SEPARATOR) ? this.getRoot() : this;
        return this._find2(0, segments, start);
    }

    private List<MxNode> _find2(int index, String[] segments, MxNode node) {
        if (index >= segments.length) {
            return new ArrayList<MxNode>();
        }
        ArrayList<MxNode> result = new ArrayList<MxNode>();
        String segment = segments[index];
        int nextIndex = index + 1;
        if (StringUtils.equals((CharSequence)".", (CharSequence)segment) || StringUtils.equalsIgnoreCase((CharSequence)node.localName, (CharSequence)this.removePredicate(segment))) {
            if (nextIndex == segments.length) {
                result.add(node);
                return result;
            }
            if (node.children != null) {
                for (MxNode n : node.children) {
                    result.addAll(this._find2(nextIndex, segments, n));
                }
                return result;
            }
        }
        return result;
    }

    private String removePredicate(String segment) {
        int index = segment.indexOf(91);
        if (index > 0) {
            return segment.substring(0, index);
        }
        return segment;
    }

    public MxNode getRoot() {
        return MxNode._getRoot(this);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "MxNode{localName='" + this.localName + '\'' + '}';
    }

    public void print() {
        PrintStream w = System.out;
        try {
            this._print(0, this.getRoot(), w);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "exception printing node structure", e);
        }
    }

    private void _print(int level, MxNode node, PrintStream w) throws IOException {
        for (int i = 0; i < level; ++i) {
            w.write("   ".getBytes());
        }
        w.write((node.localName + "\n").getBytes());
        int nextLevel = level + 1;
        for (MxNode child : node.children) {
            this._print(nextLevel, child, w);
        }
    }

    public MxNode getParent() {
        return this.parent;
    }

    public MxNode findFirstByName(String name) {
        return this._findFirstByName(this, name);
    }

    private MxNode _findFirstByName(MxNode node, String name) {
        if (node == null) {
            return null;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)node.localName, (CharSequence)name)) {
            return node;
        }
        if (node.children != null) {
            for (MxNode child : node.children) {
                MxNode found = this._findFirstByName(child, name);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public List<MxNode> getChildren() {
        return this.children;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.remove(name);
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public String path() {
        if (this.parent == null) {
            return PATH_SEPARATOR + this.localName;
        }
        return this.parent.path() + PATH_SEPARATOR + this.localName;
    }

    public void removeEmptyElements() {
        if (this.children != null && !this.children.isEmpty()) {
            ArrayList<MxNode> removables = new ArrayList<MxNode>();
            for (MxNode child : this.children) {
                if (child.isEmpty()) {
                    removables.add(child);
                    continue;
                }
                child.removeEmptyElements();
            }
            for (MxNode removable : removables) {
                this.children.remove(removable);
            }
        }
    }

    public boolean isEmpty() {
        return !(!StringUtils.isEmpty((CharSequence)this.value) || this.attributes != null && !this.attributes.isEmpty() || this.children != null && !this.children.isEmpty());
    }
}

