/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.JaxbContextLoader;
import com.prowidesoftware.swift.model.mx.MxWrite;
import com.prowidesoftware.swift.model.mx.MxWriteParams;
import com.prowidesoftware.swift.model.mx.MxWriteUtils;
import com.prowidesoftware.swift.model.mx.XmlEventWriter;
import com.prowidesoftware.swift.model.mx.XsysNamespaces;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;

public class MxWriteImpl
implements MxWrite {
    private static final Logger log = Logger.getLogger(MxWriteImpl.class.getName());

    public static String write(String namespace, AbstractMX obj, Class[] classes, MxWriteParams params) {
        Objects.requireNonNull(namespace, "namespace can not be null");
        Objects.requireNonNull(obj, "AbstractMX can not be null");
        Objects.requireNonNull(classes, "Class[] can not be null");
        Objects.requireNonNull(params, "marshalling params cannot be null");
        try {
            JAXBContext context = params.context != null ? params.context : JaxbContextLoader.INSTANCE.get(obj);
            JAXBElement element = new JAXBElement(new QName("Document"), ((Object)((Object)obj)).getClass(), null, (Object)obj);
            Marshaller marshaller = MxWriteUtils.createMarshaller(context, params);
            StringWriter sw = new StringWriter();
            XmlEventWriter writer = new XmlEventWriter(sw, params.prefix, params.includeXMLDeclaration, "Document", params.escapeHandler, params.indent);
            HashMap<String, String> preferredPrefixes = new HashMap<String, String>();
            for (XsysNamespaces xsys : XsysNamespaces.values()) {
                preferredPrefixes.put(xsys.namespaceURI(), xsys.prefix());
            }
            writer.setPreferredPrefixes(preferredPrefixes);
            marshaller.marshal((Object)element, (XMLEventWriter)writer);
            if (log.isLoggable(Level.FINER)) {
                log.finer("XML: \n" + sw.getBuffer().toString());
            }
            return sw.getBuffer().toString();
        }
        catch (ExecutionException | JAXBException e) {
            log.log(Level.SEVERE, "Error writing XML:" + e + "\n for message: " + (Object)((Object)obj));
            return null;
        }
    }
}

