
package com.prowidesoftware.swift.model.mx.dic;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import com.prowidesoftware.swift.model.mx.adapters.IsoDateAdapter;
import com.prowidesoftware.swift.model.mx.adapters.IsoDateTimeAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * Provides details of the trade transaction.
 * 
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TradeTransaction50", propOrder = {
    "txId",
    "scndryTxId",
    "prrTxId",
    "sbsqntTxId",
    "collPrtflCd",
    "rptTrckgNb",
    "pltfmIdr",
    "mrrrOrTrggrTx",
    "txPric",
    "ntnlAmt",
    "ntnlQty",
    "qty",
    "dlvryTp",
    "exctnTmStmp",
    "fctvDt",
    "xprtnDt",
    "earlyTermntnDt",
    "sttlmDt",
    "mstrAgrmt",
    "cmprssn",
    "pstTradRskRdctnFlg",
    "pstTradRskRdctnEvt",
    "derivEvt",
    "tradConf",
    "nonStdsdTerm",
    "tradClr",
    "blckTradElctn",
    "lrgNtnlOffFcltyElctn",
    "intrstRate",
    "ccy",
    "cmmdty",
    "optn",
    "nrgySpcfcAttrbts",
    "cdt",
    "othrPmt",
    "packg",
    "tradAllcnSts"
})
public class TradeTransaction50 {

    @XmlElement(name = "TxId")
    protected UniqueTransactionIdentifier2Choice txId;
    @XmlElement(name = "ScndryTxId")
    protected String scndryTxId;
    @XmlElement(name = "PrrTxId")
    protected UniqueTransactionIdentifier3Choice prrTxId;
    @XmlElement(name = "SbsqntTxId")
    protected UniqueTransactionIdentifier3Choice sbsqntTxId;
    @XmlElement(name = "CollPrtflCd")
    protected CollateralPortfolioCode6Choice collPrtflCd;
    @XmlElement(name = "RptTrckgNb")
    protected String rptTrckgNb;
    @XmlElement(name = "PltfmIdr")
    protected String pltfmIdr;
    @XmlElement(name = "MrrrOrTrggrTx")
    protected Boolean mrrrOrTrggrTx;
    @XmlElement(name = "TxPric")
    protected PriceData2 txPric;
    @XmlElement(name = "NtnlAmt")
    protected NotionalAmountLegs5 ntnlAmt;
    @XmlElement(name = "NtnlQty")
    protected NotionalQuantityLegs5 ntnlQty;
    @XmlElement(name = "Qty")
    protected FinancialInstrumentQuantity32Choice qty;
    @XmlElement(name = "DlvryTp")
    @XmlSchemaType(name = "string")
    protected PhysicalTransferType4Code dlvryTp;
    @XmlElement(name = "ExctnTmStmp", type = String.class)
    @XmlJavaTypeAdapter(IsoDateTimeAdapter.class)
    @XmlSchemaType(name = "dateTime")
    protected OffsetDateTime exctnTmStmp;
    @XmlElement(name = "FctvDt", type = String.class)
    @XmlJavaTypeAdapter(IsoDateAdapter.class)
    @XmlSchemaType(name = "date")
    protected LocalDate fctvDt;
    @XmlElement(name = "XprtnDt", type = String.class)
    @XmlJavaTypeAdapter(IsoDateAdapter.class)
    @XmlSchemaType(name = "date")
    protected LocalDate xprtnDt;
    @XmlElement(name = "EarlyTermntnDt", type = String.class)
    @XmlJavaTypeAdapter(IsoDateAdapter.class)
    @XmlSchemaType(name = "date")
    protected LocalDate earlyTermntnDt;
    @XmlElement(name = "SttlmDt", type = String.class)
    @XmlJavaTypeAdapter(IsoDateAdapter.class)
    @XmlSchemaType(name = "date")
    protected List<LocalDate> sttlmDt;
    @XmlElement(name = "MstrAgrmt")
    protected MasterAgreement8 mstrAgrmt;
    @XmlElement(name = "Cmprssn")
    protected Boolean cmprssn;
    @XmlElement(name = "PstTradRskRdctnFlg")
    protected Boolean pstTradRskRdctnFlg;
    @XmlElement(name = "PstTradRskRdctnEvt")
    protected PTRREvent2 pstTradRskRdctnEvt;
    @XmlElement(name = "DerivEvt")
    protected DerivativeEvent6 derivEvt;
    @XmlElement(name = "TradConf")
    protected TradeConfirmation4Choice tradConf;
    @XmlElement(name = "NonStdsdTerm")
    protected Boolean nonStdsdTerm;
    @XmlElement(name = "TradClr")
    protected TradeClearing11 tradClr;
    @XmlElement(name = "BlckTradElctn")
    protected Boolean blckTradElctn;
    @XmlElement(name = "LrgNtnlOffFcltyElctn")
    protected Boolean lrgNtnlOffFcltyElctn;
    @XmlElement(name = "IntrstRate")
    protected InterestRateLegs14 intrstRate;
    @XmlElement(name = "Ccy")
    protected CurrencyExchange22 ccy;
    @XmlElement(name = "Cmmdty")
    protected AssetClassCommodity7Choice cmmdty;
    @XmlElement(name = "Optn")
    protected OptionOrSwaption11 optn;
    @XmlElement(name = "NrgySpcfcAttrbts")
    protected EnergySpecificAttribute9 nrgySpcfcAttrbts;
    @XmlElement(name = "Cdt")
    protected CreditDerivative4 cdt;
    @XmlElement(name = "OthrPmt")
    protected List<OtherPayment5> othrPmt;
    @XmlElement(name = "Packg")
    protected Package4 packg;
    @XmlElement(name = "TradAllcnSts")
    @XmlSchemaType(name = "string")
    protected AllocationIndicator1Code tradAllcnSts;

    /**
     * Gets the value of the txId property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueTransactionIdentifier2Choice }
     *     
     */
    public UniqueTransactionIdentifier2Choice getTxId() {
        return txId;
    }

    /**
     * Sets the value of the txId property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueTransactionIdentifier2Choice }
     *     
     */
    public TradeTransaction50 setTxId(UniqueTransactionIdentifier2Choice value) {
        this.txId = value;
        return this;
    }

    /**
     * Gets the value of the scndryTxId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getScndryTxId() {
        return scndryTxId;
    }

    /**
     * Sets the value of the scndryTxId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public TradeTransaction50 setScndryTxId(String value) {
        this.scndryTxId = value;
        return this;
    }

    /**
     * Gets the value of the prrTxId property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueTransactionIdentifier3Choice }
     *     
     */
    public UniqueTransactionIdentifier3Choice getPrrTxId() {
        return prrTxId;
    }

    /**
     * Sets the value of the prrTxId property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueTransactionIdentifier3Choice }
     *     
     */
    public TradeTransaction50 setPrrTxId(UniqueTransactionIdentifier3Choice value) {
        this.prrTxId = value;
        return this;
    }

    /**
     * Gets the value of the sbsqntTxId property.
     * 
     * @return
     *     possible object is
     *     {@link UniqueTransactionIdentifier3Choice }
     *     
     */
    public UniqueTransactionIdentifier3Choice getSbsqntTxId() {
        return sbsqntTxId;
    }

    /**
     * Sets the value of the sbsqntTxId property.
     * 
     * @param value
     *     allowed object is
     *     {@link UniqueTransactionIdentifier3Choice }
     *     
     */
    public TradeTransaction50 setSbsqntTxId(UniqueTransactionIdentifier3Choice value) {
        this.sbsqntTxId = value;
        return this;
    }

    /**
     * Gets the value of the collPrtflCd property.
     * 
     * @return
     *     possible object is
     *     {@link CollateralPortfolioCode6Choice }
     *     
     */
    public CollateralPortfolioCode6Choice getCollPrtflCd() {
        return collPrtflCd;
    }

    /**
     * Sets the value of the collPrtflCd property.
     * 
     * @param value
     *     allowed object is
     *     {@link CollateralPortfolioCode6Choice }
     *     
     */
    public TradeTransaction50 setCollPrtflCd(CollateralPortfolioCode6Choice value) {
        this.collPrtflCd = value;
        return this;
    }

    /**
     * Gets the value of the rptTrckgNb property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getRptTrckgNb() {
        return rptTrckgNb;
    }

    /**
     * Sets the value of the rptTrckgNb property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public TradeTransaction50 setRptTrckgNb(String value) {
        this.rptTrckgNb = value;
        return this;
    }

    /**
     * Gets the value of the pltfmIdr property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPltfmIdr() {
        return pltfmIdr;
    }

    /**
     * Sets the value of the pltfmIdr property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public TradeTransaction50 setPltfmIdr(String value) {
        this.pltfmIdr = value;
        return this;
    }

    /**
     * Gets the value of the mrrrOrTrggrTx property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isMrrrOrTrggrTx() {
        return mrrrOrTrggrTx;
    }

    /**
     * Sets the value of the mrrrOrTrggrTx property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TradeTransaction50 setMrrrOrTrggrTx(Boolean value) {
        this.mrrrOrTrggrTx = value;
        return this;
    }

    /**
     * Gets the value of the txPric property.
     * 
     * @return
     *     possible object is
     *     {@link PriceData2 }
     *     
     */
    public PriceData2 getTxPric() {
        return txPric;
    }

    /**
     * Sets the value of the txPric property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriceData2 }
     *     
     */
    public TradeTransaction50 setTxPric(PriceData2 value) {
        this.txPric = value;
        return this;
    }

    /**
     * Gets the value of the ntnlAmt property.
     * 
     * @return
     *     possible object is
     *     {@link NotionalAmountLegs5 }
     *     
     */
    public NotionalAmountLegs5 getNtnlAmt() {
        return ntnlAmt;
    }

    /**
     * Sets the value of the ntnlAmt property.
     * 
     * @param value
     *     allowed object is
     *     {@link NotionalAmountLegs5 }
     *     
     */
    public TradeTransaction50 setNtnlAmt(NotionalAmountLegs5 value) {
        this.ntnlAmt = value;
        return this;
    }

    /**
     * Gets the value of the ntnlQty property.
     * 
     * @return
     *     possible object is
     *     {@link NotionalQuantityLegs5 }
     *     
     */
    public NotionalQuantityLegs5 getNtnlQty() {
        return ntnlQty;
    }

    /**
     * Sets the value of the ntnlQty property.
     * 
     * @param value
     *     allowed object is
     *     {@link NotionalQuantityLegs5 }
     *     
     */
    public TradeTransaction50 setNtnlQty(NotionalQuantityLegs5 value) {
        this.ntnlQty = value;
        return this;
    }

    /**
     * Gets the value of the qty property.
     * 
     * @return
     *     possible object is
     *     {@link FinancialInstrumentQuantity32Choice }
     *     
     */
    public FinancialInstrumentQuantity32Choice getQty() {
        return qty;
    }

    /**
     * Sets the value of the qty property.
     * 
     * @param value
     *     allowed object is
     *     {@link FinancialInstrumentQuantity32Choice }
     *     
     */
    public TradeTransaction50 setQty(FinancialInstrumentQuantity32Choice value) {
        this.qty = value;
        return this;
    }

    /**
     * Gets the value of the dlvryTp property.
     * 
     * @return
     *     possible object is
     *     {@link PhysicalTransferType4Code }
     *     
     */
    public PhysicalTransferType4Code getDlvryTp() {
        return dlvryTp;
    }

    /**
     * Sets the value of the dlvryTp property.
     * 
     * @param value
     *     allowed object is
     *     {@link PhysicalTransferType4Code }
     *     
     */
    public TradeTransaction50 setDlvryTp(PhysicalTransferType4Code value) {
        this.dlvryTp = value;
        return this;
    }

    /**
     * Gets the value of the exctnTmStmp property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public OffsetDateTime getExctnTmStmp() {
        return exctnTmStmp;
    }

    /**
     * Sets the value of the exctnTmStmp property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public TradeTransaction50 setExctnTmStmp(OffsetDateTime value) {
        this.exctnTmStmp = value;
        return this;
    }

    /**
     * Gets the value of the fctvDt property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public LocalDate getFctvDt() {
        return fctvDt;
    }

    /**
     * Sets the value of the fctvDt property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public TradeTransaction50 setFctvDt(LocalDate value) {
        this.fctvDt = value;
        return this;
    }

    /**
     * Gets the value of the xprtnDt property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public LocalDate getXprtnDt() {
        return xprtnDt;
    }

    /**
     * Sets the value of the xprtnDt property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public TradeTransaction50 setXprtnDt(LocalDate value) {
        this.xprtnDt = value;
        return this;
    }

    /**
     * Gets the value of the earlyTermntnDt property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public LocalDate getEarlyTermntnDt() {
        return earlyTermntnDt;
    }

    /**
     * Sets the value of the earlyTermntnDt property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public TradeTransaction50 setEarlyTermntnDt(LocalDate value) {
        this.earlyTermntnDt = value;
        return this;
    }

    /**
     * Gets the value of the sttlmDt property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the sttlmDt property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSttlmDt().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     * @return
     *     The value of the sttlmDt property.
     */
    public List<LocalDate> getSttlmDt() {
        if (sttlmDt == null) {
            sttlmDt = new ArrayList<>();
        }
        return this.sttlmDt;
    }

    /**
     * Gets the value of the mstrAgrmt property.
     * 
     * @return
     *     possible object is
     *     {@link MasterAgreement8 }
     *     
     */
    public MasterAgreement8 getMstrAgrmt() {
        return mstrAgrmt;
    }

    /**
     * Sets the value of the mstrAgrmt property.
     * 
     * @param value
     *     allowed object is
     *     {@link MasterAgreement8 }
     *     
     */
    public TradeTransaction50 setMstrAgrmt(MasterAgreement8 value) {
        this.mstrAgrmt = value;
        return this;
    }

    /**
     * Gets the value of the cmprssn property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isCmprssn() {
        return cmprssn;
    }

    /**
     * Sets the value of the cmprssn property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TradeTransaction50 setCmprssn(Boolean value) {
        this.cmprssn = value;
        return this;
    }

    /**
     * Gets the value of the pstTradRskRdctnFlg property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isPstTradRskRdctnFlg() {
        return pstTradRskRdctnFlg;
    }

    /**
     * Sets the value of the pstTradRskRdctnFlg property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TradeTransaction50 setPstTradRskRdctnFlg(Boolean value) {
        this.pstTradRskRdctnFlg = value;
        return this;
    }

    /**
     * Gets the value of the pstTradRskRdctnEvt property.
     * 
     * @return
     *     possible object is
     *     {@link PTRREvent2 }
     *     
     */
    public PTRREvent2 getPstTradRskRdctnEvt() {
        return pstTradRskRdctnEvt;
    }

    /**
     * Sets the value of the pstTradRskRdctnEvt property.
     * 
     * @param value
     *     allowed object is
     *     {@link PTRREvent2 }
     *     
     */
    public TradeTransaction50 setPstTradRskRdctnEvt(PTRREvent2 value) {
        this.pstTradRskRdctnEvt = value;
        return this;
    }

    /**
     * Gets the value of the derivEvt property.
     * 
     * @return
     *     possible object is
     *     {@link DerivativeEvent6 }
     *     
     */
    public DerivativeEvent6 getDerivEvt() {
        return derivEvt;
    }

    /**
     * Sets the value of the derivEvt property.
     * 
     * @param value
     *     allowed object is
     *     {@link DerivativeEvent6 }
     *     
     */
    public TradeTransaction50 setDerivEvt(DerivativeEvent6 value) {
        this.derivEvt = value;
        return this;
    }

    /**
     * Gets the value of the tradConf property.
     * 
     * @return
     *     possible object is
     *     {@link TradeConfirmation4Choice }
     *     
     */
    public TradeConfirmation4Choice getTradConf() {
        return tradConf;
    }

    /**
     * Sets the value of the tradConf property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeConfirmation4Choice }
     *     
     */
    public TradeTransaction50 setTradConf(TradeConfirmation4Choice value) {
        this.tradConf = value;
        return this;
    }

    /**
     * Gets the value of the nonStdsdTerm property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isNonStdsdTerm() {
        return nonStdsdTerm;
    }

    /**
     * Sets the value of the nonStdsdTerm property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TradeTransaction50 setNonStdsdTerm(Boolean value) {
        this.nonStdsdTerm = value;
        return this;
    }

    /**
     * Gets the value of the tradClr property.
     * 
     * @return
     *     possible object is
     *     {@link TradeClearing11 }
     *     
     */
    public TradeClearing11 getTradClr() {
        return tradClr;
    }

    /**
     * Sets the value of the tradClr property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeClearing11 }
     *     
     */
    public TradeTransaction50 setTradClr(TradeClearing11 value) {
        this.tradClr = value;
        return this;
    }

    /**
     * Gets the value of the blckTradElctn property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isBlckTradElctn() {
        return blckTradElctn;
    }

    /**
     * Sets the value of the blckTradElctn property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TradeTransaction50 setBlckTradElctn(Boolean value) {
        this.blckTradElctn = value;
        return this;
    }

    /**
     * Gets the value of the lrgNtnlOffFcltyElctn property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isLrgNtnlOffFcltyElctn() {
        return lrgNtnlOffFcltyElctn;
    }

    /**
     * Sets the value of the lrgNtnlOffFcltyElctn property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public TradeTransaction50 setLrgNtnlOffFcltyElctn(Boolean value) {
        this.lrgNtnlOffFcltyElctn = value;
        return this;
    }

    /**
     * Gets the value of the intrstRate property.
     * 
     * @return
     *     possible object is
     *     {@link InterestRateLegs14 }
     *     
     */
    public InterestRateLegs14 getIntrstRate() {
        return intrstRate;
    }

    /**
     * Sets the value of the intrstRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link InterestRateLegs14 }
     *     
     */
    public TradeTransaction50 setIntrstRate(InterestRateLegs14 value) {
        this.intrstRate = value;
        return this;
    }

    /**
     * Gets the value of the ccy property.
     * 
     * @return
     *     possible object is
     *     {@link CurrencyExchange22 }
     *     
     */
    public CurrencyExchange22 getCcy() {
        return ccy;
    }

    /**
     * Sets the value of the ccy property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrencyExchange22 }
     *     
     */
    public TradeTransaction50 setCcy(CurrencyExchange22 value) {
        this.ccy = value;
        return this;
    }

    /**
     * Gets the value of the cmmdty property.
     * 
     * @return
     *     possible object is
     *     {@link AssetClassCommodity7Choice }
     *     
     */
    public AssetClassCommodity7Choice getCmmdty() {
        return cmmdty;
    }

    /**
     * Sets the value of the cmmdty property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssetClassCommodity7Choice }
     *     
     */
    public TradeTransaction50 setCmmdty(AssetClassCommodity7Choice value) {
        this.cmmdty = value;
        return this;
    }

    /**
     * Gets the value of the optn property.
     * 
     * @return
     *     possible object is
     *     {@link OptionOrSwaption11 }
     *     
     */
    public OptionOrSwaption11 getOptn() {
        return optn;
    }

    /**
     * Sets the value of the optn property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptionOrSwaption11 }
     *     
     */
    public TradeTransaction50 setOptn(OptionOrSwaption11 value) {
        this.optn = value;
        return this;
    }

    /**
     * Gets the value of the nrgySpcfcAttrbts property.
     * 
     * @return
     *     possible object is
     *     {@link EnergySpecificAttribute9 }
     *     
     */
    public EnergySpecificAttribute9 getNrgySpcfcAttrbts() {
        return nrgySpcfcAttrbts;
    }

    /**
     * Sets the value of the nrgySpcfcAttrbts property.
     * 
     * @param value
     *     allowed object is
     *     {@link EnergySpecificAttribute9 }
     *     
     */
    public TradeTransaction50 setNrgySpcfcAttrbts(EnergySpecificAttribute9 value) {
        this.nrgySpcfcAttrbts = value;
        return this;
    }

    /**
     * Gets the value of the cdt property.
     * 
     * @return
     *     possible object is
     *     {@link CreditDerivative4 }
     *     
     */
    public CreditDerivative4 getCdt() {
        return cdt;
    }

    /**
     * Sets the value of the cdt property.
     * 
     * @param value
     *     allowed object is
     *     {@link CreditDerivative4 }
     *     
     */
    public TradeTransaction50 setCdt(CreditDerivative4 value) {
        this.cdt = value;
        return this;
    }

    /**
     * Gets the value of the othrPmt property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the othrPmt property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOthrPmt().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OtherPayment5 }
     * 
     * 
     * @return
     *     The value of the othrPmt property.
     */
    public List<OtherPayment5> getOthrPmt() {
        if (othrPmt == null) {
            othrPmt = new ArrayList<>();
        }
        return this.othrPmt;
    }

    /**
     * Gets the value of the packg property.
     * 
     * @return
     *     possible object is
     *     {@link Package4 }
     *     
     */
    public Package4 getPackg() {
        return packg;
    }

    /**
     * Sets the value of the packg property.
     * 
     * @param value
     *     allowed object is
     *     {@link Package4 }
     *     
     */
    public TradeTransaction50 setPackg(Package4 value) {
        this.packg = value;
        return this;
    }

    /**
     * Gets the value of the tradAllcnSts property.
     * 
     * @return
     *     possible object is
     *     {@link AllocationIndicator1Code }
     *     
     */
    public AllocationIndicator1Code getTradAllcnSts() {
        return tradAllcnSts;
    }

    /**
     * Sets the value of the tradAllcnSts property.
     * 
     * @param value
     *     allowed object is
     *     {@link AllocationIndicator1Code }
     *     
     */
    public TradeTransaction50 setTradAllcnSts(AllocationIndicator1Code value) {
        this.tradAllcnSts = value;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    /**
     * Adds a new item to the sttlmDt list.
     * @see #getSttlmDt()
     * 
     */
    public TradeTransaction50 addSttlmDt(LocalDate sttlmDt) {
        getSttlmDt().add(sttlmDt);
        return this;
    }

    /**
     * Adds a new item to the othrPmt list.
     * @see #getOthrPmt()
     * 
     */
    public TradeTransaction50 addOthrPmt(OtherPayment5 othrPmt) {
        getOthrPmt().add(othrPmt);
        return this;
    }

}
