/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import com.prowidesoftware.swift.WifeException;
import com.prowidesoftware.swift.io.IConversionService;
import com.prowidesoftware.swift.io.parser.SwiftParser;
import com.prowidesoftware.swift.io.parser.XMLParser;
import com.prowidesoftware.swift.io.writer.SwiftWriter;
import com.prowidesoftware.swift.io.writer.XMLWriterVisitor;
import com.prowidesoftware.swift.model.SwiftMessage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.Validate;

public class ConversionService
implements IConversionService {
    private static final transient Logger log = Logger.getLogger(ConversionService.class.getName());

    public String getFIN(SwiftMessage swiftMessage) {
        Validate.notNull((Object)swiftMessage);
        SwiftWriter swiftWriter = new SwiftWriter();
        StringWriter stringWriter = new StringWriter();
        swiftWriter.writeMessage(swiftMessage, stringWriter);
        String string = stringWriter.getBuffer().toString();
        String string2 = ConversionService.ensureEols(string);
        return string2.substring(0, string2.length() - "\r\n".length());
    }

    private static String ensureEols(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\r\n");
            }
        }
        catch (Exception exception) {
            log.severe("Error in EOL correction: " + exception);
        }
        return stringBuilder.toString();
    }

    public String getFIN(String string) {
        Validate.notNull((Object)string);
        SwiftMessage swiftMessage = this.getMessageFromXML(string);
        if (swiftMessage == null) {
            throw new RuntimeException("SwiftMessage is null");
        }
        return this.getFIN(swiftMessage);
    }

    public String getXml(SwiftMessage swiftMessage) {
        return this.getXml(swiftMessage, false);
    }

    public String getXml(SwiftMessage swiftMessage, boolean bl) {
        Validate.notNull((Object)swiftMessage);
        StringWriter stringWriter = new StringWriter();
        swiftMessage.visit(new XMLWriterVisitor(stringWriter, bl));
        String string = stringWriter.getBuffer().toString();
        if (log.isLoggable(Level.FINE)) {
            log.fine("xml: " + string);
        }
        return string;
    }

    public String getXml(String string) {
        return this.getXml(string, false);
    }

    public String getXml(String string, boolean bl) {
        Validate.notNull((Object)string);
        SwiftMessage swiftMessage = this.getMessageFromFIN(string);
        return this.getXml(swiftMessage, bl);
    }

    public SwiftMessage getMessageFromFIN(String string) {
        Validate.notNull((Object)string);
        SwiftParser swiftParser = new SwiftParser(new ByteArrayInputStream(string.getBytes()));
        try {
            return swiftParser.message();
        }
        catch (IOException iOException) {
            throw new WifeException(iOException + " during parse of message");
        }
    }

    public SwiftMessage getMessageFromXML(String string) {
        return new XMLParser().parse(string);
    }
}

