/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPCFileReader
implements Iterator<String>,
Iterable<String> {
    private static int BEGIN = 1;
    private static int END = 3;
    private final FileReader reader;
    private static final Logger log = Logger.getLogger(PPCFileReader.class.getName());
    private int curChar = 0;

    public PPCFileReader(File file) throws FileNotFoundException {
        this.reader = new FileReader(file);
    }

    @Override
    public boolean hasNext() {
        Reader reader = this.getReader();
        while (this.curChar != -1 && this.curChar != BEGIN) {
            try {
                this.curChar = reader.read();
            }
            catch (IOException iOException) {
                log.severe("IOException while reading: " + iOException);
                return false;
            }
        }
        return this.curChar == BEGIN;
    }

    private Reader getReader() {
        if (this.reader == null) {
            throw new IllegalStateException("reader is null");
        }
        return this.reader;
    }

    @Override
    public String next() {
        if (this.curChar == BEGIN) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            do {
                try {
                    this.curChar = this.reader.read();
                }
                catch (IOException iOException) {
                    log.severe("error reading: " + iOException);
                    throw new RuntimeException(iOException);
                }
                if (this.curChar == -1 || this.curChar == END) {
                    bl = true;
                    continue;
                }
                stringBuilder.append((char)this.curChar);
            } while (!bl);
            return stringBuilder.toString();
        }
        throw new IllegalStateException("hasNext did not return true but this method was called");
    }

    @Override
    public void remove() {
        throw new RuntimeException("remove not avaiable in this implementation");
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

