/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderIterator
implements Iterable<String>,
Iterator<String> {
    private final Reader reader;

    public ReaderIterator(Reader reader) {
        this.reader = reader;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    public static ReaderIterator fromResource(String string) {
        InputStream inputStream = ReaderIterator.class.getClassLoader().getResourceAsStream(string);
        if (inputStream != null) {
            return new ReaderIterator(new InputStreamReader(inputStream));
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.reader.ready();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public String next() {
        if (this.reader != null) {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                int n;
                while ((n = this.reader.read()) != -1 && n != 36) {
                    stringBuilder.append((char)n);
                }
                if (n == -1) {
                    this.reader.close();
                }
            }
            catch (IOException iOException) {
                return null;
            }
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

