/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.parser;

import com.prowidesoftware.swift.model.MxNode;
import com.prowidesoftware.swift.model.mx.dic.ApplicationHeader;
import com.prowidesoftware.swift.model.mx.dic.DuplicateIndication;
import com.prowidesoftware.swift.model.mx.dic.EntityIdentification;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MxParser {
    private static final transient String APP_HEADER = "<ApplicationHeader></ApplicationHeader>";

    public MxNode parse(InputStream inputStream) {
        return this.parse(new InputSource(inputStream));
    }

    public MxNode parse(Reader reader) {
        return this.parse(new InputSource(reader));
    }

    private MxNode parse(InputSource inputSource) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            ContentHandler contentHandler = new ContentHandler();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(contentHandler);
            xMLReader.parse(inputSource);
            return contentHandler.getRootNode();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static ApplicationHeader parseApplicationHeader_jaxb() throws Exception {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ApplicationHeader.class, DuplicateIndication.class, EntityIdentification.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        long l = System.currentTimeMillis();
        unmarshaller.unmarshal((Reader)new StringReader(APP_HEADER));
        long l2 = System.currentTimeMillis();
        System.out.println("JAXB parse: " + (l2 - l) + "ms");
        return null;
    }

    public static ApplicationHeader parseApplicationHeader_sax() {
        MxParser mxParser = new MxParser();
        StringReader stringReader = new StringReader(APP_HEADER);
        long l = System.currentTimeMillis();
        MxNode mxNode = mxParser.parse(stringReader);
        long l2 = System.currentTimeMillis();
        System.out.println("SAX parse: " + (l2 - l) + "ms");
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            MxParser.parseApplicationHeader_sax();
            MxParser.parseApplicationHeader_jaxb();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static final class ContentHandler
    implements org.xml.sax.ContentHandler {
        private static final transient Logger log = Logger.getLogger(ContentHandler.class.getName());
        private MxNode currentNode;
        private MxNode rootNode;

        private ContentHandler() {
        }

        private MxNode getRootNode() {
            return this.rootNode;
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
            this.currentNode = null;
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            MxNode mxNode;
            if (log.isLoggable(Level.FINE)) {
                log.fine("uri: " + string + "\nlocalName: " + string2 + "\nqName: " + string3 + (attributes == null ? "" : "\natts(" + attributes.getLength() + "): ..."));
            }
            this.currentNode = mxNode = new MxNode(this.currentNode, string2);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            log.finer("end: " + string2);
            if (this.currentNode.getParent() == null) {
                this.rootNode = this.currentNode;
            }
            this.currentNode = this.currentNode.getParent();
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            String string = new String(cArray, n, n2);
            log.finer("characters: " + string);
            this.currentNode.setValue(string);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
            log.fine("skippedEntity: " + string);
        }
    }
}

