/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.parser;

import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2Input;
import com.prowidesoftware.swift.model.SwiftBlock2Output;
import com.prowidesoftware.swift.model.SwiftBlock3;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftBlock5;
import com.prowidesoftware.swift.model.SwiftBlockUser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.UnparsedTextList;
import java.io.ByteArrayInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLParser {
    private static final transient Logger log = Logger.getLogger(XMLParser.class.getName());

    public SwiftMessage parse(String string) {
        Validate.notNull((Object)string);
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
            return this.createMessage(document);
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Error parsing XML", exception);
            return null;
        }
    }

    private SwiftMessage createMessage(Document document) {
        NodeList nodeList = document.getElementsByTagName("message");
        if (nodeList.getLength() == 1) {
            Node node = nodeList.item(0);
            SwiftMessage swiftMessage = new SwiftMessage(false);
            NodeList nodeList2 = node.getChildNodes();
            if (log.isLoggable(Level.FINE)) {
                log.fine("blocks in message: " + nodeList2.getLength());
            }
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node2 = nodeList2.item(i);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("evaluating node " + node2.getNodeName());
                }
                if (node2.getNodeType() != 1) continue;
                String string = node2.getNodeName();
                if (string.equalsIgnoreCase("block1")) {
                    swiftMessage.setBlock1(this.getBlock1FromNode(node2));
                    continue;
                }
                if (string.equalsIgnoreCase("block2")) {
                    swiftMessage.setBlock2(this.getBlock2FromNode(node2));
                    continue;
                }
                if (string.equalsIgnoreCase("unparsedtexts")) {
                    swiftMessage.setUnparsedTexts(this.getUnparsedTextsFromNode(node2));
                    continue;
                }
                swiftMessage.addBlock(this.getTagListBlockFromNode(node2));
            }
            return swiftMessage;
        }
        throw new IllegalArgumentException("<message> tag not found");
    }

    private SwiftBlock1 getBlock1FromNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(nodeList.getLength() + " children in <block1>");
        }
        SwiftBlock1 swiftBlock1 = new SwiftBlock1();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("APPLICATIONID".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock1.setApplicationId(this.getText(node2));
                continue;
            }
            if ("SERVICEID".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock1.setServiceId(this.getText(node2));
                continue;
            }
            if ("LOGICALTERMINAL".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock1.setLogicalTerminal(this.getText(node2));
                continue;
            }
            if ("SESSIONNUMBER".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock1.setSessionNumber(this.getText(node2));
                continue;
            }
            if ("SEQUENCENUMBER".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock1.setSequenceNumber(this.getText(node2));
                continue;
            }
            if (!"unparsedTexts".equalsIgnoreCase(node2.getNodeName())) continue;
            swiftBlock1.setUnparsedTexts(this.getUnparsedTextsFromNode(node2));
        }
        return swiftBlock1;
    }

    private String getText(Node node) {
        String string = null;
        Node node2 = node.getFirstChild();
        if (node2 != null && node2.getNodeType() == 3) {
            string = node2.getNodeValue().trim();
        } else {
            log.warning("Node is not TEXT_NODE: " + node2);
        }
        log.fine("text: " + string);
        return string;
    }

    private SwiftBlock2 getBlock2FromNode(Node node) {
        String string = this.getNodeAttribute(node, "type");
        if (string == null) {
            log.severe("atrribute 'type' was expected but not found at <block2> xml tag");
            return null;
        }
        if (string.equals("input")) {
            return this.getBlock2InputFromNode(node);
        }
        if (string.equals("output")) {
            return this.getBlock2OutputFromNode(node);
        }
        log.severe("expected 'input' or 'output' value for 'type' atribute at <block2> xml tag, and found: " + string);
        return null;
    }

    private SwiftBlock2Input getBlock2InputFromNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(nodeList.getLength() + " childrens in <block2 type=\"input\">");
        }
        SwiftBlock2Input swiftBlock2Input = new SwiftBlock2Input();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("MESSAGETYPE".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Input.setMessageType(this.getText(node2));
                continue;
            }
            if ("RECEIVERADDRESS".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Input.setReceiverAddress(this.getText(node2));
                continue;
            }
            if ("MESSAGEPRIORITY".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Input.setMessagePriority(this.getText(node2));
                continue;
            }
            if ("DELIVERYMONITORING".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Input.setDeliveryMonitoring(this.getText(node2));
                continue;
            }
            if ("OBSOLESCENCEPERIOD".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Input.setObsolescencePeriod(this.getText(node2));
                continue;
            }
            if (!"unparsedTexts".equalsIgnoreCase(node2.getNodeName())) continue;
            swiftBlock2Input.setUnparsedTexts(this.getUnparsedTextsFromNode(node2));
        }
        return swiftBlock2Input;
    }

    private SwiftBlock2Output getBlock2OutputFromNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(nodeList.getLength() + " childrens in <block2 type=\"output\">");
        }
        SwiftBlock2Output swiftBlock2Output = new SwiftBlock2Output();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("MESSAGETYPE".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Output.setMessageType(this.getText(node2));
                continue;
            }
            if ("SENDERINPUTTIME".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Output.setSenderInputTime(this.getText(node2));
                continue;
            }
            if ("MIRDATE".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Output.setMIRDate(this.getText(node2));
                continue;
            }
            if ("MIRLOGICALTERMINAL".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Output.setMIRLogicalTerminal(this.getText(node2));
                continue;
            }
            if ("MIRSESSIONNUMBER".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Output.setMIRSessionNumber(this.getText(node2));
                continue;
            }
            if ("MIRSEQUENCENUMBER".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Output.setMIRSequenceNumber(this.getText(node2));
                continue;
            }
            if ("RECEIVEROUTPUTDATE".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Output.setReceiverOutputDate(this.getText(node2));
                continue;
            }
            if ("RECEIVEROUTPUTTIME".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Output.setReceiverOutputTime(this.getText(node2));
                continue;
            }
            if ("MESSAGEPRIORITY".equalsIgnoreCase(node2.getNodeName())) {
                swiftBlock2Output.setMessagePriority(this.getText(node2));
                continue;
            }
            if (!"unparsedTexts".equalsIgnoreCase(node2.getNodeName())) continue;
            swiftBlock2Output.setUnparsedTexts(this.getUnparsedTextsFromNode(node2));
        }
        return swiftBlock2Output;
    }

    private SwiftTagListBlock getTagListBlockFromNode(Node node) {
        Object object;
        String string = node.getNodeName();
        SwiftTagListBlock swiftTagListBlock = null;
        if (string.equalsIgnoreCase("block3")) {
            swiftTagListBlock = new SwiftBlock3();
        } else if (string.equalsIgnoreCase("block4")) {
            swiftTagListBlock = new SwiftBlock4();
        } else if (string.equalsIgnoreCase("block5")) {
            swiftTagListBlock = new SwiftBlock5();
        } else if (string.equalsIgnoreCase("block")) {
            object = this.getNodeAttribute(node, "name");
            swiftTagListBlock = object != null ? new SwiftBlockUser((String)object) : new SwiftBlockUser();
        } else {
            return null;
        }
        object = node.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(object.getLength() + " children in tag list " + string);
        }
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            if ("tag".equalsIgnoreCase(node2.getNodeName())) {
                Tag tag = this.getTag(node2);
                swiftTagListBlock.addTag(tag);
                continue;
            }
            if (!"unparsedtexts".equalsIgnoreCase(node2.getNodeName())) continue;
            swiftTagListBlock.setUnparsedTexts(this.getUnparsedTextsFromNode(node2));
        }
        return swiftTagListBlock;
    }

    private Tag getTag(Node node) {
        Tag tag = new Tag();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("name".equalsIgnoreCase(node2.getNodeName())) {
                tag.setName(this.getText(node2));
            }
            if ("value".equalsIgnoreCase(node2.getNodeName())) {
                String string = this.getText(node2);
                string = StringUtils.replace((String)string, (String)"\n", (String)"\r\n");
                tag.setValue(string);
                continue;
            }
            if (!"unparsedtexts".equalsIgnoreCase(node2.getNodeName())) continue;
            tag.setUnparsedTexts(this.getUnparsedTextsFromNode(node2));
        }
        return tag;
    }

    private UnparsedTextList getUnparsedTextsFromNode(Node node) {
        UnparsedTextList unparsedTextList = new UnparsedTextList();
        NodeList nodeList = node.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(nodeList.getLength() + " children in <unparsedtexts>");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!"text".equalsIgnoreCase(node2.getNodeName())) continue;
            unparsedTextList.addText(this.getText(node2));
        }
        return unparsedTextList;
    }

    private String getNodeAttribute(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null || !node2.getNodeName().equals(string)) {
            return null;
        }
        return node2.getNodeValue();
    }
}

