/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.ISOCountries;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IBAN {
    private static final BigInteger BD_97 = new BigInteger("97");
    private static final BigInteger BD_98 = new BigInteger("98");
    private String invalidCause = null;
    private String iban;
    private static final transient Logger log = Logger.getLogger(IBAN.class.getName());

    public String getIban() {
        return this.iban;
    }

    public void setIban(String string) {
        this.iban = string;
    }

    public IBAN(String string) {
        this.iban = string;
    }

    public boolean isValid() {
        String string;
        int n;
        if (this.iban == null) {
            throw new IllegalStateException("iban is null");
        }
        this.invalidCause = null;
        String string2 = this.removeNonAlpha(this.iban);
        int n2 = string2.length();
        if (n2 < 4) {
            this.invalidCause = "Too short (expected at least 4, got " + n2 + ")";
            return false;
        }
        String string3 = string2.substring(0, 2);
        if (!ISOCountries.getInstance().isValidCode(string3)) {
            this.invalidCause = "Invalid ISO country code: " + string3;
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(string2.substring(4));
        if (stringBuffer.length() == 0) {
            this.invalidCause = "Empty Basic Bank Account Number";
            return false;
        }
        stringBuffer.append(string2.substring(0, 4));
        if (log.isLoggable(Level.FINE)) {
            log.fine("bban: " + stringBuffer);
        }
        if ((n = this.modulo97(string = this.translateChars(stringBuffer))) != 1) {
            this.invalidCause = "Verification failed (expected 1 and obtained " + n + ")";
            return false;
        }
        return true;
    }

    public String translateChars(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (Character.isLetter(c)) {
                stringBuffer2.append(Character.getNumericValue(c));
                continue;
            }
            stringBuffer2.append(c);
        }
        return stringBuffer2.toString();
    }

    public String removeNonAlpha(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c)) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private int modulo97(String string) {
        BigInteger bigInteger = new BigInteger(string);
        bigInteger = bigInteger.divideAndRemainder(BD_97)[1];
        bigInteger = BD_98.min(bigInteger);
        bigInteger = bigInteger.divideAndRemainder(BD_97)[1];
        return bigInteger.intValue();
    }

    public String getInvalidCause() {
        return this.invalidCause;
    }
}

