/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.AbstractSwiftMessage;
import com.prowidesoftware.swift.model.MxBusinessProcess;
import com.prowidesoftware.swift.model.mx.dic.ApplicationHeader;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class MxSwiftMessage
extends AbstractSwiftMessage {
    private static final long serialVersionUID = 1L;
    private MxBusinessProcess businessProcess;
    private String functionality;
    private String variant;
    private String version;
    private ApplicationHeader applicationHeader;

    public MxBusinessProcess getBusinessProcess() {
        return this.businessProcess;
    }

    public void setBusinessProcess(MxBusinessProcess mxBusinessProcess) {
        this.businessProcess = mxBusinessProcess;
    }

    public String getFunctionality() {
        return this.functionality;
    }

    public void setFunctionality(String string) {
        this.functionality = string;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String string) {
        this.variant = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.businessProcess == null ? 0 : this.businessProcess.hashCode());
        n = 31 * n + (this.functionality == null ? 0 : this.functionality.hashCode());
        n = 31 * n + (this.variant == null ? 0 : this.variant.hashCode());
        n = 31 * n + (this.version == null ? 0 : this.version.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MxSwiftMessage mxSwiftMessage = (MxSwiftMessage)object;
        if (this.businessProcess != mxSwiftMessage.businessProcess) {
            return false;
        }
        if (this.functionality == null ? mxSwiftMessage.functionality != null : !this.functionality.equals(mxSwiftMessage.functionality)) {
            return false;
        }
        if (this.variant == null ? mxSwiftMessage.variant != null : !this.variant.equals(mxSwiftMessage.variant)) {
            return false;
        }
        return !(this.version == null ? mxSwiftMessage.version != null : !this.version.equals(mxSwiftMessage.version));
    }

    public MxSwiftMessage readFile(File file) throws IOException {
        MxSwiftMessage mxSwiftMessage = new MxSwiftMessage();
        mxSwiftMessage.setMessage(Lib.readFile(file));
        mxSwiftMessage.setFilename(file.getAbsolutePath());
        return mxSwiftMessage;
    }

    protected void setDataFromNamespace(String string) {
        MxBusinessProcess mxBusinessProcess;
        Validate.notNull((Object)string, (String)"namespace can not be null");
        String[] stringArray = StringUtils.split((String)string, (char)'.');
        if (stringArray == null || stringArray.length < 4) {
            throw new RuntimeException("Expected at least 4 tokens in namespace '" + string + "'");
        }
        String string2 = stringArray[stringArray.length - 4];
        String string3 = stringArray[stringArray.length - 3];
        String string4 = stringArray[stringArray.length - 2];
        String string5 = stringArray[stringArray.length - 1];
        try {
            mxBusinessProcess = MxBusinessProcess.valueOf(string2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unknown business process '" + string2 + "'");
        }
        this.setBusinessProcess(mxBusinessProcess);
        this.setFunctionality(string3);
        this.setVariant(string4);
        this.setVersion(string5);
    }

    public ApplicationHeader getApplicationHeader() {
        return this.applicationHeader;
    }

    public void setApplicationHeader(ApplicationHeader applicationHeader) {
        this.applicationHeader = applicationHeader;
    }
}

