/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.UnparsedTextList;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class SwiftBlock
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Long id;
    protected UnparsedTextList unparsedTexts = null;
    protected Boolean input;
    protected Boolean output;
    protected String blockType;

    public String getBlockType() {
        return this.blockType;
    }

    public void setBlockType(String string) {
        this.blockType = string;
    }

    public SwiftBlock() {
    }

    public SwiftBlock(UnparsedTextList unparsedTextList) {
        this.unparsedTexts = unparsedTextList;
    }

    protected abstract void setBlockNumber(Integer var1);

    protected abstract void setBlockName(String var1);

    public abstract Integer getNumber();

    public abstract String getName();

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean isTagBlock() {
        return this instanceof SwiftTagListBlock;
    }

    protected void unparsedTextVerify() {
        if (this.unparsedTexts == null) {
            this.unparsedTexts = new UnparsedTextList();
        }
    }

    public UnparsedTextList getUnparsedTexts() {
        this.unparsedTextVerify();
        return this.unparsedTexts;
    }

    public void setUnparsedTexts(UnparsedTextList unparsedTextList) {
        this.unparsedTexts = unparsedTextList;
    }

    public Integer getUnparsedTextsSize() {
        if (this.unparsedTexts == null) {
            return new Integer(0);
        }
        return this.unparsedTexts.size();
    }

    public Boolean unparsedTextIsMessage(Integer n) {
        this.unparsedTextVerify();
        return this.unparsedTexts.isMessage(n);
    }

    public String unparsedTextGetText(Integer n) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getText(n);
    }

    public SwiftMessage unparsedTextGetAsMessage(Integer n) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getTextAsMessage(n);
    }

    public void unparsedTextAddText(String string) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(string);
    }

    public void unparsedTextAddText(SwiftMessage swiftMessage) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(swiftMessage);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.unparsedTexts == null ? 0 : this.unparsedTexts.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SwiftBlock swiftBlock = (SwiftBlock)object;
        return !(this.unparsedTexts == null ? swiftBlock.unparsedTexts != null : !this.unparsedTexts.equals(swiftBlock.unparsedTexts));
    }

    public Boolean getInput() {
        return new Boolean(StringUtils.equals((String)this.getBlockType(), (String)"2I"));
    }

    public void setInput(Boolean bl) {
        this.input = bl;
    }

    public Boolean getOutput() {
        return new Boolean(StringUtils.equals((String)this.getBlockType(), (String)"2O"));
    }

    public void setOutput(Boolean bl) {
        this.output = bl;
    }
}

