/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.SwiftValueBlock;
import java.io.Serializable;
import org.apache.commons.lang.Validate;

public class SwiftBlock1
extends SwiftValueBlock
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final transient String APPLICATION_ID_FIN = "F";
    public static final transient String APPLICATION_ID_GPA = "A";
    public static final transient String APPLICATION_ID_LOGINS = "L";
    private String applicationId = "F";
    private String serviceId = "01";
    private String logicalTerminal;
    private String sessionNumber = "0000";
    private String sequenceNumber = "000000";

    public SwiftBlock1(String string, String string2, String string3, String string4, String string5) {
        this.applicationId = string;
        this.serviceId = string2;
        this.logicalTerminal = string3;
        this.sessionNumber = string4;
        this.sequenceNumber = string5;
    }

    public SwiftBlock1() {
    }

    public SwiftBlock1(String string) {
        this.setValue(string);
    }

    protected void setBlockNumber(Integer n) {
        Validate.notNull((Object)n, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((n == 1 ? 1 : 0) != 0, (String)"blockNumber must be 1");
    }

    protected void setBlockName(String string) {
        Validate.notNull((Object)string, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((string.compareTo("1") == 0 ? 1 : 0) != 0, (String)"blockName must be string '1'");
    }

    public Integer getNumber() {
        return new Integer(1);
    }

    public String getName() {
        return "1";
    }

    public void setApplicationId(String string) {
        this.applicationId = string;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setServiceId(String string) {
        this.serviceId = string;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setLogicalTerminal(String string) {
        this.logicalTerminal = string;
    }

    public void setLogicalTerminal(LogicalTerminalAddress logicalTerminalAddress) {
        this.logicalTerminal = logicalTerminalAddress.getSenderLogicalTerminalAddress();
    }

    public void setLogicalTerminal(BIC bIC) {
        this.setLogicalTerminal(new LogicalTerminalAddress(bIC.getBic11()));
    }

    public void setSender(String string) {
        this.setLogicalTerminal(new LogicalTerminalAddress(string));
    }

    public BIC getBIC() {
        return new BIC(this.logicalTerminal);
    }

    public String getLogicalTerminal() {
        return this.logicalTerminal;
    }

    public void setSessionNumber(String string) {
        this.sessionNumber = string;
    }

    public String getSessionNumber() {
        return this.sessionNumber;
    }

    public void setSequenceNumber(String string) {
        this.sequenceNumber = string;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean isEmpty() {
        return this.applicationId == null && this.serviceId == null && this.logicalTerminal == null && this.sessionNumber == null && this.sequenceNumber == null;
    }

    public String getValue() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.applicationId != null) {
            stringBuffer.append(this.applicationId);
        }
        if (this.serviceId != null) {
            stringBuffer.append(this.serviceId);
        }
        if (this.logicalTerminal != null) {
            stringBuffer.append(this.logicalTerminal);
        }
        if (this.sessionNumber != null) {
            stringBuffer.append(this.sessionNumber);
        }
        if (this.sequenceNumber != null) {
            stringBuffer.append(this.sequenceNumber);
        }
        return stringBuffer.toString();
    }

    public String getBlockValue() {
        return this.getValue();
    }

    public void setValue(String string) {
        Validate.notNull((Object)string, (String)"value must not be null");
        int n = 0;
        int n2 = string.length();
        if (string.startsWith("1")) {
            Validate.isTrue((boolean)string.startsWith("1:"), (String)("expected '1:' at the beginning of value and found '" + string.substring(0, 1) + "'"));
            Validate.isTrue((n2 == 26 || n2 == 27 ? 1 : 0) != 0, (String)("block value " + string + " cannot be parsed because it has an invalid size, expected 26 or 27 and found " + string.length()));
            n = 2;
        } else {
            Validate.isTrue((n2 == 24 || n2 == 25 ? 1 : 0) != 0, (String)("block value " + string + " cannot be parsed because it has an invalid size, expected 24 or 25 and found " + string.length()));
            n2 += 2;
        }
        int n3 = 1;
        this.setApplicationId(this.getValuePart(string, n, n3));
        n += n3;
        n3 = 2;
        this.setServiceId(this.getValuePart(string, n, n3));
        n += n3;
        n3 = n2 == 26 ? 11 : 12;
        this.setLogicalTerminal(this.getValuePart(string, n, n3));
        n += n3;
        n3 = 4;
        this.setSessionNumber(this.getValuePart(string, n, n3));
        n += n3;
        n3 = 6;
        this.setSequenceNumber(this.getValuePart(string, n, n3));
        n += n3;
    }

    public void setBlockValue(String string) {
        this.setValue(string);
    }

    public void clean() {
        this.applicationId = null;
        this.serviceId = null;
        this.logicalTerminal = null;
        this.sessionNumber = null;
        this.sequenceNumber = null;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.applicationId == null ? 0 : this.applicationId.hashCode());
        n = 31 * n + (this.logicalTerminal == null ? 0 : this.logicalTerminal.hashCode());
        n = 31 * n + (this.sequenceNumber == null ? 0 : this.sequenceNumber.hashCode());
        n = 31 * n + (this.serviceId == null ? 0 : this.serviceId.hashCode());
        n = 31 * n + (this.sessionNumber == null ? 0 : this.sessionNumber.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SwiftBlock1 swiftBlock1 = (SwiftBlock1)object;
        if (this.applicationId == null ? swiftBlock1.applicationId != null : !this.applicationId.equals(swiftBlock1.applicationId)) {
            return false;
        }
        if (this.logicalTerminal == null ? swiftBlock1.logicalTerminal != null : !this.logicalTerminal.equals(swiftBlock1.logicalTerminal)) {
            return false;
        }
        if (this.sequenceNumber == null ? swiftBlock1.sequenceNumber != null : !this.sequenceNumber.equals(swiftBlock1.sequenceNumber)) {
            return false;
        }
        if (this.serviceId == null ? swiftBlock1.serviceId != null : !this.serviceId.equals(swiftBlock1.serviceId)) {
            return false;
        }
        return !(this.sessionNumber == null ? swiftBlock1.sessionNumber != null : !this.sessionNumber.equals(swiftBlock1.sessionNumber));
    }

    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ \n");
        stringBuilder.append("\"applicationId\" : ").append("\"").append(this.applicationId).append("\", \n");
        stringBuilder.append("\"serviceId\" : ").append("\"").append(this.serviceId).append("\", \n");
        stringBuilder.append("\"logicalTerminal\" : \"").append(this.logicalTerminal).append("\", \n");
        stringBuilder.append("\"sessionNumber\" : \"").append(this.sessionNumber).append("\", \n");
        stringBuilder.append("\"sequenceNumber\" : \"").append(this.sequenceNumber).append("\" \n");
        stringBuilder.append("} ");
        return stringBuilder.toString();
    }
}

