/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwiftBlockUser
extends SwiftTagListBlock
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Integer sortKey;
    protected String blockName;

    public SwiftBlockUser() {
        this.setBlockName("0");
    }

    public SwiftBlockUser(Integer n) {
        Validate.notNull((Object)n, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(n), (String)"'blockNumber' is not a valid User Defined Block number");
        this.setBlockNumber(n);
    }

    public SwiftBlockUser(Integer n, List<Tag> list) {
        Validate.notNull((Object)n, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(n), (String)"'blockNumber' is not a valid User Defined Block number");
        Validate.allElementsOfType(list, Tag.class, (String)"parameter 'tags' may only have Tag elements");
        this.setBlockNumber(n);
        this.addTags(list);
    }

    public SwiftBlockUser(String string) {
        Validate.notNull((Object)string, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(string), (String)"'blockName' is not a valid User Defined Block name");
        this.setBlockName(string);
    }

    public SwiftBlockUser(String string, List<Tag> list) {
        Validate.notNull((Object)string, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(string), (String)"'blockName' is not a valid User Defined Block name");
        Validate.allElementsOfType(list, Tag.class, (String)"parameter 'tags' may only have Tag elements");
        this.setBlockName(string);
        this.addTags(list);
    }

    @Override
    public Integer getNumber() {
        Integer n = new Integer(-1);
        try {
            n = Integer.decode(this.blockName);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public String getName() {
        return this.getBlockName();
    }

    public String getBlockName() {
        return this.blockName;
    }

    @Override
    protected void setBlockNumber(Integer n) {
        Validate.notNull((Object)n, (String)"parameter 'blockNumber' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(n), (String)("'" + n.toString() + "' is not a valid User Defined Block number"));
        this.blockName = n.toString();
    }

    @Override
    protected void setBlockName(String string) {
        Validate.notNull((Object)string, (String)"parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(string), (String)("'" + string + "' is not a valid User Defined Block name"));
        this.blockName = string;
    }

    protected Boolean isValidName() {
        return SwiftBlockUser.isValidName(this.getName(), this.getNumber());
    }

    public static Boolean isValidName(String string, Integer n) {
        return SwiftBlockUser.isValidName(string) != false && SwiftBlockUser.isValidName(n) != false;
    }

    public static Boolean isValidName(String string) {
        if (string == null) {
            return Boolean.FALSE;
        }
        try {
            Integer n = Integer.decode(string);
            if (!SwiftBlockUser.isValidName(n).booleanValue()) {
                return Boolean.FALSE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (string.length() != 1) {
            return Boolean.FALSE;
        }
        char c = Character.toLowerCase(string.charAt(0));
        if (!('0' <= c && c <= '9' || 'a' <= c && c <= 'z')) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isValidName(Integer n) {
        if (n == null) {
            return Boolean.FALSE;
        }
        if (n != -1 && 1 <= n && n <= 5) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Integer getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(Integer n) {
        this.sortKey = n;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.blockName == null ? 0 : this.blockName.hashCode());
        n = 31 * n + (this.sortKey == null ? 0 : this.sortKey.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SwiftBlockUser swiftBlockUser = (SwiftBlockUser)object;
        if (this.blockName == null ? swiftBlockUser.blockName != null : !this.blockName.equals(swiftBlockUser.blockName)) {
            return false;
        }
        return !(this.sortKey == null ? swiftBlockUser.sortKey != null : !this.sortKey.equals(swiftBlockUser.sortKey));
    }
}

