/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32A;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwiftMessageUtils {
    private final SwiftMessage msg;

    public SwiftMessageUtils() {
        this(null);
    }

    public SwiftMessageUtils(SwiftMessage swiftMessage) {
        this.msg = swiftMessage;
    }

    public List<String> currencyStrings() {
        return SwiftMessageUtils.currencyStrings(this.msg);
    }

    public static List<String> currencyStrings(SwiftMessage swiftMessage) {
        SwiftBlock4 swiftBlock4;
        if (swiftMessage != null && (swiftBlock4 = swiftMessage.getBlock4()) != null && !swiftBlock4.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Tag tag : swiftBlock4.getTags()) {
                Field field = tag.getField();
                if (!(field instanceof CurrencyContainer)) continue;
                CurrencyContainer currencyContainer = (CurrencyContainer)((Object)field);
                arrayList.addAll(currencyContainer.currencyStrings());
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public Calendar valueDate() {
        return SwiftMessageUtils.valueDate(this.msg);
    }

    public static Calendar valueDate(SwiftMessage swiftMessage) {
        SwiftBlock4 swiftBlock4;
        if (swiftMessage != null && (swiftBlock4 = swiftMessage.getBlock4()) != null && !swiftBlock4.isEmpty()) {
            if (swiftBlock4.containsTag("32A")) {
                Field32A field32A = (Field32A)swiftBlock4.getTagByName("32A").getField();
                return field32A.getComponent1AsCalendar();
            }
            if (swiftBlock4.containsTag("30")) {
                Field30 field30 = (Field30)swiftBlock4.getTagByName("30").getField();
                return field30.getComponent1AsCalendar();
            }
        }
        return null;
    }

    public static String calculateChecksum(SwiftMessage swiftMessage) {
        return null;
    }
}

