/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field19A
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer,
GenericField {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "19A";
    public static final String F_19A = "19A";
    public static final String PARSER_PATTERN = ":S//[c]SN";
    public static final String COMPONENTS_PATTERN = "SSCN";

    public static Tag tag(String string) {
        return new Tag("19A", string);
    }

    public static Tag emptyTag() {
        return new Tag("19A", "");
    }

    public Field19A() {
        super(4);
    }

    public Field19A(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getTokenFirst(string, ":", "//"));
        String string2 = SwiftParseUtils.getTokenSecondLast(string, "//");
        String string3 = SwiftParseUtils.getAlphaPrefix(string2);
        if (string3 != null && string3.length() >= 4) {
            this.setComponent2(StringUtils.substring((String)string3, (int)0, (int)1));
            this.setComponent3(StringUtils.substring((String)string3, (int)1));
        } else if (string2 != null && string2.length() >= 3) {
            this.setComponent3(string3);
        }
        this.setComponent4(SwiftParseUtils.getNumericSuffix(string2));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        stringBuilder.append("//");
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field19A setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field19A setQualifier(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getSign() {
        return this.getComponent(2);
    }

    public Field19A setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field19A setSign(String string) {
        this.setComponent(2, string);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getCurrency() {
        return this.getComponent(3);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public Field19A setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field19A setComponent3(Currency currency) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field19A setCurrency(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field19A setCurrency(Currency currency) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getAmount() {
        return this.getComponent(4);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field19A setComponent4(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field19A setComponent4(Number number) {
        this.setComponent(4, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field19A setAmount(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field19A setAmount(Number number) {
        this.setComponent(4, SwiftFormatUtils.getNumber(number));
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        return n == 2;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent2();
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "19A";
    }

    public static Field19A get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field19A)swiftTagListBlock.getFieldByName("19A");
    }

    public static Field19A get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field19A.get(swiftMessage.getBlock4());
    }

    public static List<Field19A> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field19A.getAll(swiftMessage.getBlock4());
    }

    public static List<Field19A> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("19A");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field19A> arrayList = new ArrayList<Field19A>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field19A)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

