/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field258
extends Field
implements Serializable,
DateContainer,
BICContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "258";
    public static final String F_258 = "258";
    public static final String PARSER_PATTERN = "S4!N3!N<DATE2>[<HHMM><HHMM>]";
    public static final String COMPONENTS_PATTERN = "BNNEHH";

    public static Tag tag(String string) {
        return new Tag("258", string);
    }

    public static Tag emptyTag() {
        return new Tag("258", "");
    }

    public Field258() {
        super(6);
    }

    public Field258(String string) {
        this();
        if (string != null) {
            this.setComponent1(SwiftParseUtils.getAlphaPrefix(string));
            String string2 = SwiftParseUtils.getNumericSuffix(string);
            if (string2.length() >= 4) {
                this.setComponent2(StringUtils.substring((String)string2, (int)0, (int)4));
            }
            if (string.length() >= 7) {
                this.setComponent3(StringUtils.substring((String)string2, (int)4, (int)7));
            }
            if (string.length() >= 13) {
                this.setComponent4(StringUtils.substring((String)string2, (int)7, (int)13));
            }
            if (string.length() >= 17) {
                this.setComponent5(StringUtils.substring((String)string2, (int)13, (int)17));
            }
            if (string.length() > 17) {
                this.setComponent6(StringUtils.substring((String)string2, (int)17));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        if (StringUtils.isNotEmpty((String)this.getComponent5())) {
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        }
        if (StringUtils.isNotEmpty((String)this.getComponent6())) {
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent6()));
        }
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public BIC getComponent1AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(1));
    }

    public String getBIC() {
        return this.getComponent(1);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(1));
    }

    public Field258 setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field258 setComponent1(BIC bIC) {
        this.setComponent(1, SwiftFormatUtils.getBIC(bIC));
        return this;
    }

    public Field258 setBIC(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field258 setBIC(BIC bIC) {
        this.setComponent(1, SwiftFormatUtils.getBIC(bIC));
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getSessionNumber() {
        return this.getComponent(2);
    }

    public Number getSessionNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field258 setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field258 setComponent2(Number number) {
        this.setComponent(2, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field258 setSessionNumber(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field258 setSessionNumber(Number number) {
        this.setComponent(2, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getMessageType() {
        return this.getComponent(3);
    }

    public Number getMessageTypeAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field258 setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field258 setComponent3(Number number) {
        this.setComponent(3, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field258 setMessageType(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field258 setMessageType(Number number) {
        this.setComponent(3, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(4));
    }

    public String getDate() {
        return this.getComponent(4);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(4));
    }

    public Field258 setComponent4(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field258 setComponent4(Calendar calendar) {
        this.setComponent(4, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public Field258 setDate(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field258 setDate(Calendar calendar) {
        this.setComponent(4, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Calendar getComponent5AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(5));
    }

    public String getStartTime() {
        return this.getComponent(5);
    }

    public Calendar getStartTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(5));
    }

    public Field258 setComponent5(String string) {
        this.setComponent(5, string);
        return this;
    }

    public Field258 setComponent5(Calendar calendar) {
        this.setComponent(5, SwiftFormatUtils.getTime3(calendar));
        return this;
    }

    public Field258 setStartTime(String string) {
        this.setComponent(5, string);
        return this;
    }

    public Field258 setStartTime(Calendar calendar) {
        this.setComponent(5, SwiftFormatUtils.getTime3(calendar));
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Calendar getComponent6AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(6));
    }

    public String getEndTime() {
        return this.getComponent(6);
    }

    public Calendar getEndTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(6));
    }

    public Field258 setComponent6(String string) {
        this.setComponent(6, string);
        return this;
    }

    public Field258 setComponent6(Calendar calendar) {
        this.setComponent(6, SwiftFormatUtils.getTime3(calendar));
        return this;
    }

    public Field258 setEndTime(String string) {
        this.setComponent(6, string);
        return this;
    }

    public Field258 setEndTime(Calendar calendar) {
        this.setComponent(6, SwiftFormatUtils.getTime3(calendar));
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        arrayList.add(SwiftFormatUtils.getDate2(this.getComponent(4)));
        arrayList.add(SwiftFormatUtils.getTime3(this.getComponent(5)));
        arrayList.add(SwiftFormatUtils.getTime3(this.getComponent(6)));
        return arrayList;
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> arrayList = new ArrayList<BIC>();
        arrayList.add(SwiftFormatUtils.getBIC(this.getComponent(1)));
        return arrayList;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getComponent(1));
        return arrayList;
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "258";
    }

    public static Field258 get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field258)swiftTagListBlock.getFieldByName("258");
    }

    public static Field258 get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field258.get(swiftMessage.getBlock4());
    }

    public static List<Field258> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field258.getAll(swiftMessage.getBlock4());
    }

    public static List<Field258> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("258");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field258> arrayList = new ArrayList<Field258>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field258)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

