/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field260
extends Field
implements Serializable,
DateContainer,
BICContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "260";
    public static final String F_260 = "260";
    public static final String PARSER_PATTERN = "12!S<DATE2><HHMM><HHMM>[N]";
    public static final String COMPONENTS_PATTERN = "BEHHN";

    public static Tag tag(String string) {
        return new Tag("260", string);
    }

    public static Tag emptyTag() {
        return new Tag("260", "");
    }

    public Field260() {
        super(5);
    }

    public Field260(String string) {
        this();
        if (string != null) {
            if (string.length() >= 12) {
                this.setComponent1(StringUtils.substring((String)string, (int)0, (int)12));
            }
            if (string.length() >= 18) {
                this.setComponent2(StringUtils.substring((String)string, (int)12, (int)18));
            }
            if (string.length() >= 22) {
                this.setComponent3(StringUtils.substring((String)string, (int)18, (int)22));
            }
            if (string.length() >= 26) {
                this.setComponent4(StringUtils.substring((String)string, (int)22, (int)26));
            }
            if (string.length() >= 26) {
                this.setComponent5(StringUtils.substring((String)string, (int)26));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        if (StringUtils.isNotEmpty((String)this.getComponent5())) {
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        }
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public BIC getComponent1AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(1));
    }

    public String getBIC() {
        return this.getComponent(1);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(1));
    }

    public Field260 setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field260 setComponent1(BIC bIC) {
        this.setComponent(1, SwiftFormatUtils.getBIC(bIC));
        return this;
    }

    public Field260 setBIC(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field260 setBIC(BIC bIC) {
        this.setComponent(1, SwiftFormatUtils.getBIC(bIC));
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent(2);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public Field260 setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field260 setComponent2(Calendar calendar) {
        this.setComponent(2, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public Field260 setDate(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field260 setDate(Calendar calendar) {
        this.setComponent(2, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public String getStartTime() {
        return this.getComponent(3);
    }

    public Calendar getStartTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public Field260 setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field260 setComponent3(Calendar calendar) {
        this.setComponent(3, SwiftFormatUtils.getTime3(calendar));
        return this;
    }

    public Field260 setStartTime(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field260 setStartTime(Calendar calendar) {
        this.setComponent(3, SwiftFormatUtils.getTime3(calendar));
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(4));
    }

    public String getEndTime() {
        return this.getComponent(4);
    }

    public Calendar getEndTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(4));
    }

    public Field260 setComponent4(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field260 setComponent4(Calendar calendar) {
        this.setComponent(4, SwiftFormatUtils.getTime3(calendar));
        return this;
    }

    public Field260 setEndTime(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field260 setEndTime(Calendar calendar) {
        this.setComponent(4, SwiftFormatUtils.getTime3(calendar));
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Number getComponent5AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public String getSessionNumber() {
        return this.getComponent(5);
    }

    public Number getSessionNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public Field260 setComponent5(String string) {
        this.setComponent(5, string);
        return this;
    }

    public Field260 setComponent5(Number number) {
        this.setComponent(5, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field260 setSessionNumber(String string) {
        this.setComponent(5, string);
        return this;
    }

    public Field260 setSessionNumber(Number number) {
        this.setComponent(5, SwiftFormatUtils.getNumber(number));
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        arrayList.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        arrayList.add(SwiftFormatUtils.getTime3(this.getComponent(3)));
        arrayList.add(SwiftFormatUtils.getTime3(this.getComponent(4)));
        return arrayList;
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> arrayList = new ArrayList<BIC>();
        arrayList.add(SwiftFormatUtils.getBIC(this.getComponent(1)));
        return arrayList;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getComponent(1));
        return arrayList;
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "260";
    }

    public static Field260 get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field260)swiftTagListBlock.getFieldByName("260");
    }

    public static Field260 get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field260.get(swiftMessage.getBlock4());
    }

    public static List<Field260> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field260.getAll(swiftMessage.getBlock4());
    }

    public static List<Field260> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("260");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field260> arrayList = new ArrayList<Field260>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field260)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

