/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field26N
extends Field
implements Serializable,
CurrencyContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "26N";
    public static final String F_26N = "26N";
    public static final String PARSER_PATTERN = "S/S";
    public static final String COMPONENTS_PATTERN = "CS";

    public static Tag tag(String string) {
        return new Tag("26N", string);
    }

    public static Tag emptyTag() {
        return new Tag("26N", "");
    }

    public Field26N() {
        super(2);
    }

    public Field26N(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getTokenFirst(string, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(string, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Currency getComponent1AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public String getCurrency() {
        return this.getComponent(1);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public Field26N setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field26N setComponent1(Currency currency) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field26N setCurrency(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field26N setCurrency(Currency currency) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public Field26N setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "26N";
    }

    public static Field26N get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field26N)swiftTagListBlock.getFieldByName("26N");
    }

    public static Field26N get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field26N.get(swiftMessage.getBlock4());
    }

    public static List<Field26N> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field26N.getAll(swiftMessage.getBlock4());
    }

    public static List<Field26N> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("26N");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field26N> arrayList = new ArrayList<Field26N>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field26N)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

