/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field32E
extends Field
implements Serializable,
CurrencyContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "32E";
    public static final String F_32E = "32E";
    public static final String PARSER_PATTERN = "S";
    public static final String COMPONENTS_PATTERN = "C";

    public static Tag tag(String string) {
        return new Tag("32E", string);
    }

    public static Tag emptyTag() {
        return new Tag("32E", "");
    }

    public Field32E() {
        super(1);
    }

    public Field32E(String string) {
        this();
        this.setComponent1(string);
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Currency getComponent1AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public String getCurrency() {
        return this.getComponent(1);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public Field32E setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field32E setComponent1(Currency currency) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field32E setCurrency(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field32E setCurrency(Currency currency) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "32E";
    }

    public static Field32E get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field32E)swiftTagListBlock.getFieldByName("32E");
    }

    public static Field32E get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field32E.get(swiftMessage.getBlock4());
    }

    public static List<Field32E> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field32E.getAll(swiftMessage.getBlock4());
    }

    public static List<Field32E> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("32E");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field32E> arrayList = new ArrayList<Field32E>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field32E)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

