/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field34G
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "34G";
    public static final String F_34G = "34G";
    public static final String PARSER_PATTERN = "SNS";
    public static final String COMPONENTS_PATTERN = "NCN";

    public static Tag tag(String string) {
        return new Tag("34G", string);
    }

    public static Tag emptyTag() {
        return new Tag("34G", "");
    }

    public Field34G() {
        super(3);
    }

    public Field34G(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(string));
        String string2 = this.getComponent1() == null ? string : StringUtils.substringAfter((String)string, (String)this.getComponent1());
        this.setComponent2(SwiftParseUtils.getNumericPrefix(string2));
        this.setComponent3(SwiftParseUtils.getAlphaSuffix(string2));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.joinComponents());
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getCurrency() {
        return this.getComponent(1);
    }

    public Number getCurrencyAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public Field34G setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field34G setComponent1(Number number) {
        this.setComponent(1, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field34G setCurrency(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field34G setCurrency(Number number) {
        this.setComponent(1, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getAmount() {
        return this.getComponent(2);
    }

    public Currency getAmountAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public Field34G setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field34G setComponent2(Currency currency) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field34G setAmount(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field34G setAmount(Currency currency) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field34G setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field34G setComponent3(Number number) {
        this.setComponent(3, SwiftFormatUtils.getNumber(number));
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        return n == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "34G";
    }

    public static Field34G get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field34G)swiftTagListBlock.getFieldByName("34G");
    }

    public static Field34G get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field34G.get(swiftMessage.getBlock4());
    }

    public static List<Field34G> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field34G.getAll(swiftMessage.getBlock4());
    }

    public static List<Field34G> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("34G");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field34G> arrayList = new ArrayList<Field34G>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field34G)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

