/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field41A
extends Field
implements Serializable,
BICContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "41A";
    public static final String F_41A = "41A";
    public static final String PARSER_PATTERN = "S$S";
    public static final String COMPONENTS_PATTERN = "BS";

    public static Tag tag(String string) {
        return new Tag("41A", string);
    }

    public static Tag emptyTag() {
        return new Tag("41A", "");
    }

    public Field41A() {
        super(2);
    }

    public Field41A(String string) {
        this();
        List<String> list = SwiftParseUtils.getLines(string);
        if (list.size() > 0) {
            this.setComponent1(list.get(0));
        }
        if (list.size() > 1) {
            this.setComponent2(list.get(1));
        }
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            stringBuilder.append("\r\n");
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public BIC getComponent1AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(1));
    }

    public String getBIC() {
        return this.getComponent(1);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(1));
    }

    public Field41A setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field41A setComponent1(BIC bIC) {
        this.setComponent(1, SwiftFormatUtils.getBIC(bIC));
        return this;
    }

    public Field41A setBIC(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field41A setBIC(BIC bIC) {
        this.setComponent(1, SwiftFormatUtils.getBIC(bIC));
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public Field41A setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> arrayList = new ArrayList<BIC>();
        arrayList.add(SwiftFormatUtils.getBIC(this.getComponent(1)));
        return arrayList;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getComponent(1));
        return arrayList;
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "41A";
    }

    public static Field41A get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field41A)swiftTagListBlock.getFieldByName("41A");
    }

    public static Field41A get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field41A.get(swiftMessage.getBlock4());
    }

    public static List<Field41A> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field41A.getAll(swiftMessage.getBlock4());
    }

    public static List<Field41A> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("41A");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field41A> arrayList = new ArrayList<Field41A>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field41A)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

