/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field50A
extends Field
implements Serializable,
BICContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "50A";
    public static final String F_50A = "50A";
    public static final String PARSER_PATTERN = "[/S$]S";
    public static final String COMPONENTS_PATTERN = "SB";

    public static Tag tag(String string) {
        return new Tag("50A", string);
    }

    public static Tag emptyTag() {
        return new Tag("50A", "");
    }

    public Field50A() {
        super(2);
    }

    public Field50A(String string) {
        this();
        List<String> list = SwiftParseUtils.getLines(string);
        if (list.size() > 0) {
            if (list.get(0).startsWith("/")) {
                this.setComponent1(StringUtils.substring((String)list.get(0), (int)1));
                SwiftParseUtils.setComponentsFromLines(this, 2, 4, 1, list);
            } else {
                SwiftParseUtils.setComponentsFromLines(this, 2, 4, 0, list);
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((String)this.getComponent1())) {
            stringBuilder.append("/");
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        }
        this.appendInLines(stringBuilder, this.getComponent2());
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getAccount() {
        String string = this.getComponent(1);
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '/') continue;
                return string.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field50A setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field50A setAccount(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BIC getComponent2AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public String getBIC() {
        return this.getComponent(2);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public Field50A setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field50A setComponent2(BIC bIC) {
        this.setComponent(2, SwiftFormatUtils.getBIC(bIC));
        return this;
    }

    public Field50A setBIC(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field50A setBIC(BIC bIC) {
        this.setComponent(2, SwiftFormatUtils.getBIC(bIC));
        return this;
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> arrayList = new ArrayList<BIC>();
        arrayList.add(SwiftFormatUtils.getBIC(this.getComponent(2)));
        return arrayList;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getComponent(2));
        return arrayList;
    }

    @Override
    public boolean isOptional(int n) {
        return n == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "50A";
    }

    public static Field50A get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field50A)swiftTagListBlock.getFieldByName("50A");
    }

    public static Field50A get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field50A.get(swiftMessage.getBlock4());
    }

    public static List<Field50A> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field50A.getAll(swiftMessage.getBlock4());
    }

    public static List<Field50A> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("50A");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field50A> arrayList = new ArrayList<Field50A>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field50A)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

