/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field50G
extends Field
implements Serializable,
BICContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "50G";
    public static final String F_50G = "50G";
    public static final String PARSER_PATTERN = "/S$S";
    public static final String COMPONENTS_PATTERN = "SB";

    public static Tag tag(String string) {
        return new Tag("50G", string);
    }

    public static Tag emptyTag() {
        return new Tag("50G", "");
    }

    public Field50G() {
        super(2);
    }

    public Field50G(String string) {
        this();
        List<String> list = SwiftParseUtils.getLines(string);
        if (list.size() > 0) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(list.get(0), "/", null));
        }
        if (list.size() > 1) {
            this.setComponent2(list.get(1));
        }
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            stringBuilder.append("\r\n");
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        }
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getAccount() {
        String string = this.getComponent(1);
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '/') continue;
                return string.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field50G setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field50G setAccount(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BIC getComponent2AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public String getBIC() {
        return this.getComponent(2);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public Field50G setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field50G setComponent2(BIC bIC) {
        this.setComponent(2, SwiftFormatUtils.getBIC(bIC));
        return this;
    }

    public Field50G setBIC(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field50G setBIC(BIC bIC) {
        this.setComponent(2, SwiftFormatUtils.getBIC(bIC));
        return this;
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> arrayList = new ArrayList<BIC>();
        arrayList.add(SwiftFormatUtils.getBIC(this.getComponent(2)));
        return arrayList;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getComponent(2));
        return arrayList;
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "50G";
    }

    public static Field50G get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field50G)swiftTagListBlock.getFieldByName("50G");
    }

    public static Field50G get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field50G.get(swiftMessage.getBlock4());
    }

    public static List<Field50G> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field50G.getAll(swiftMessage.getBlock4());
    }

    public static List<Field50G> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("50G");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field50G> arrayList = new ArrayList<Field50G>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field50G)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

