/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field53B
extends Field
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "53B";
    public static final String F_53B = "53B";
    public static final String PARSER_PATTERN = "[[/c][/S]$][S]";
    public static final String COMPONENTS_PATTERN = "SSS";

    public static Tag tag(String string) {
        return new Tag("53B", string);
    }

    public static Tag emptyTag() {
        return new Tag("53B", "");
    }

    public Field53B() {
        super(3);
    }

    public Field53B(String string) {
        this();
        List<String> list = SwiftParseUtils.getLines(string);
        if (list.size() > 0) {
            if (list.get(0).startsWith("/")) {
                if (list.get(0).startsWith("//")) {
                    this.setComponent1("");
                    this.setComponent2(StringUtils.substring((String)list.get(0), (int)2));
                } else {
                    String string2 = SwiftParseUtils.getTokenFirst(list.get(0), "/", "/");
                    if (StringUtils.isNotEmpty((String)string2)) {
                        if (string2.length() == 1) {
                            this.setComponent1(string2);
                            this.setComponent2(SwiftParseUtils.getTokenSecondLast(StringUtils.substring((String)list.get(0), (int)1), "/"));
                        } else {
                            this.setComponent2(StringUtils.substring((String)list.get(0), (int)1));
                        }
                    }
                }
                if (list.size() > 1) {
                    this.setComponent3(list.get(1));
                }
            } else {
                this.setComponent3(list.get(0));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.getComponent1() != null) {
            stringBuilder.append("/" + StringUtils.trimToEmpty((String)this.getComponent1()));
            bl = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            stringBuilder.append("/" + StringUtils.trimToEmpty((String)this.getComponent2()));
            bl = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent3())) {
            if (bl) {
                stringBuilder.append("\r\n");
            }
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        }
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public Field53B setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field53B setDCMark(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getAccount() {
        String string = this.getComponent(2);
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '/') continue;
                return string.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field53B setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field53B setAccount(String string) {
        this.setComponent(2, string);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getLocation() {
        return this.getComponent(3);
    }

    public Field53B setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field53B setLocation(String string) {
        this.setComponent(3, string);
        return this;
    }

    @Override
    public boolean isOptional(int n) {
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return true;
        }
        return n == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "53B";
    }

    public static Field53B get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field53B)swiftTagListBlock.getFieldByName("53B");
    }

    public static Field53B get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field53B.get(swiftMessage.getBlock4());
    }

    public static List<Field53B> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field53B.getAll(swiftMessage.getBlock4());
    }

    public static List<Field53B> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("53B");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field53B> arrayList = new ArrayList<Field53B>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field53B)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    @Deprecated
    public String getDC() {
        return this.getDCMark();
    }

    @Deprecated
    public void setDC(String string) {
        this.setDCMark(string);
    }

    @Override
    public String getValueDisplay() {
        return Field53B.formatAccount(this.getComponent2());
    }
}

