/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field62F
extends Field
implements Serializable,
DateContainer,
AmountContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "62F";
    public static final String F_62F = "62F";
    public static final String PARSER_PATTERN = "[c]<DATE2>SN";
    public static final String COMPONENTS_PATTERN = "SESN";

    public static Tag tag(String string) {
        return new Tag("62F", string);
    }

    public static Tag emptyTag() {
        return new Tag("62F", "");
    }

    public Field62F() {
        super(4);
    }

    public Field62F(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(string));
        String string2 = SwiftParseUtils.getNumericSuffix(string);
        this.setComponent2(SwiftParseUtils.getNumericPrefix(string2));
        String string3 = SwiftParseUtils.getAlphaSuffix(string2);
        this.setComponent3(SwiftParseUtils.getAlphaPrefix(string3));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(string3));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.joinComponents());
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public Field62F setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field62F setDCMark(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent(2);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public Field62F setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field62F setComponent2(Calendar calendar) {
        this.setComponent(2, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public Field62F setDate(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field62F setDate(Calendar calendar) {
        this.setComponent(2, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getCurrency() {
        return this.getComponent(3);
    }

    public Field62F setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field62F setCurrency(String string) {
        this.setComponent(3, string);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getAmount() {
        return this.getComponent(4);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field62F setComponent4(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field62F setComponent4(Number number) {
        this.setComponent(4, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field62F setAmount(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field62F setAmount(Number number) {
        this.setComponent(4, SwiftFormatUtils.getNumber(number));
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        arrayList.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        return arrayList;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        return n == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "62F";
    }

    public static Field62F get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field62F)swiftTagListBlock.getFieldByName("62F");
    }

    public static Field62F get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field62F.get(swiftMessage.getBlock4());
    }

    public static List<Field62F> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field62F.getAll(swiftMessage.getBlock4());
    }

    public static List<Field62F> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("62F");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field62F> arrayList = new ArrayList<Field62F>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field62F)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

