/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field68A
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "68A";
    public static final String F_68A = "68A";
    public static final String PARSER_PATTERN = "NSN/N[/N][//S]";
    public static final String COMPONENTS_PATTERN = "NCNNNS";

    public static Tag tag(String string) {
        return new Tag("68A", string);
    }

    public static Tag emptyTag() {
        return new Tag("68A", "");
    }

    public Field68A() {
        super(6);
    }

    public Field68A(String string) {
        this();
        String string2 = SwiftParseUtils.getTokenFirst(string, "/");
        this.setComponent1(SwiftParseUtils.getNumericPrefix(string2));
        String string3 = SwiftParseUtils.getAlphaSuffix(string2);
        this.setComponent2(SwiftParseUtils.getAlphaPrefix(string3));
        this.setComponent3(SwiftParseUtils.getNumericSuffix(string3));
        this.setComponent4(SwiftParseUtils.getTokenSecond(string, "/"));
        string2 = SwiftParseUtils.getTokenThirdLast(string, "/");
        this.setComponent5(SwiftParseUtils.getTokenFirst(string2, "//"));
        this.setComponent6(SwiftParseUtils.getTokenSecond(string2, "//"));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        if (StringUtils.isNotEmpty((String)this.getComponent5())) {
            stringBuilder.append("/");
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        }
        if (StringUtils.isNotEmpty((String)this.getComponent6())) {
            stringBuilder.append("//");
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent6()));
        }
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public Field68A setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field68A setComponent1(Number number) {
        this.setComponent(1, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public Field68A setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field68A setComponent2(Currency currency) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field68A setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field68A setComponent3(Number number) {
        this.setComponent(3, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field68A setComponent4(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field68A setComponent4(Number number) {
        this.setComponent(4, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Number getComponent5AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public Field68A setComponent5(String string) {
        this.setComponent(5, string);
        return this;
    }

    public Field68A setComponent5(Number number) {
        this.setComponent(5, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    @Deprecated
    public String getComponent6AsString() {
        return this.getComponent(6);
    }

    public Field68A setComponent6(String string) {
        this.setComponent(6, string);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        if (n == 5) {
            return true;
        }
        return n == 6;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "68A";
    }

    public static Field68A get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field68A)swiftTagListBlock.getFieldByName("68A");
    }

    public static Field68A get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field68A.get(swiftMessage.getBlock4());
    }

    public static List<Field68A> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field68A.getAll(swiftMessage.getBlock4());
    }

    public static List<Field68A> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("68A");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field68A> arrayList = new ArrayList<Field68A>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field68A)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

