/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field68B
extends Field
implements Serializable,
CurrencyContainer,
DateContainer,
AmountContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "68B";
    public static final String F_68B = "68B";
    public static final String PARSER_PATTERN = "<DATE2><DATE2>S/cSN$SN/<DATE2>SN";
    public static final String COMPONENTS_PATTERN = "EEScSNCNECN";

    public static Tag tag(String string) {
        return new Tag("68B", string);
    }

    public static Tag emptyTag() {
        return new Tag("68B", "");
    }

    public Field68B() {
        super(11);
    }

    public Field68B(String string) {
        this();
        String string2;
        List<String> list = SwiftParseUtils.getLines(string);
        if (list.size() > 0 && list.get(0) != null) {
            string2 = SwiftParseUtils.getTokenFirst(list.get(0), "/");
            if (string2 != null && string2.length() >= 6) {
                this.setComponent1(StringUtils.substring((String)string2, (int)0, (int)6));
            }
            if (string2 != null && string2.length() >= 12) {
                this.setComponent2(StringUtils.substring((String)string2, (int)6, (int)12));
            }
            if (string2 != null && string2.length() > 12) {
                this.setComponent3(StringUtils.substring((String)string2, (int)12));
            }
            if ((string2 = SwiftParseUtils.getAlphaPrefix(SwiftParseUtils.getTokenSecond(list.get(0), "/"))) != null && string2.length() >= 1) {
                this.setComponent4(StringUtils.substring((String)string2, (int)0, (int)1));
            }
            if (string2 != null && string2.length() > 1) {
                this.setComponent5(StringUtils.substring((String)string2, (int)1));
            }
            this.setComponent6(SwiftParseUtils.getNumericSuffix(SwiftParseUtils.getTokenSecond(list.get(0), "/")));
        }
        if (list.size() > 1 && list.get(1) != null) {
            string2 = SwiftParseUtils.getTokenFirst(list.get(1), "/");
            this.setComponent7(SwiftParseUtils.getAlphaPrefix(string2));
            this.setComponent8(SwiftParseUtils.getNumericSuffix(string2));
            string2 = SwiftParseUtils.getTokenSecondLast(list.get(1), "/");
            if (string2 != null && string2.length() >= 6) {
                this.setComponent9(StringUtils.substring((String)string2, (int)0, (int)6));
                String string3 = StringUtils.substring((String)string2, (int)6);
                this.setComponent10(SwiftParseUtils.getAlphaPrefix(string3));
                this.setComponent11(SwiftParseUtils.getNumericSuffix(string3));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent6()));
        stringBuilder.append("\r\n");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent7()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent8()));
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent9()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent10()));
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent11()));
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public String getTradeDate() {
        return this.getComponent(1);
    }

    public Calendar getTradeDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public Field68B setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field68B setComponent1(Calendar calendar) {
        this.setComponent(1, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public Field68B setTradeDate(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field68B setTradeDate(Calendar calendar) {
        this.setComponent(1, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getMaturityDate() {
        return this.getComponent(2);
    }

    public Calendar getMaturityDateAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public Field68B setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field68B setComponent2(Calendar calendar) {
        this.setComponent(2, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public Field68B setMaturityDate(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field68B setMaturityDate(Calendar calendar) {
        this.setComponent(2, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getContractNumber() {
        return this.getComponent(3);
    }

    public Field68B setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field68B setContractNumber(String string) {
        this.setComponent(3, string);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getIndicator() {
        return this.getComponent(4);
    }

    public Field68B setComponent4(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field68B setIndicator(String string) {
        this.setComponent(4, string);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public String getUnit() {
        return this.getComponent(5);
    }

    public Field68B setComponent5(String string) {
        this.setComponent(5, string);
        return this;
    }

    public Field68B setUnit(String string) {
        this.setComponent(5, string);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public Number getComponent6AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public String getQuantityOfTheCommodity() {
        return this.getComponent(6);
    }

    public Number getQuantityOfTheCommodityAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(6));
    }

    public Field68B setComponent6(String string) {
        this.setComponent(6, string);
        return this;
    }

    public Field68B setComponent6(Number number) {
        this.setComponent(6, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field68B setQuantityOfTheCommodity(String string) {
        this.setComponent(6, string);
        return this;
    }

    public Field68B setQuantityOfTheCommodity(Number number) {
        this.setComponent(6, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public String getComponent7() {
        return this.getComponent(7);
    }

    public Currency getComponent7AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(7));
    }

    public String getPricePerUnitCurrency() {
        return this.getComponent(7);
    }

    public Currency getPricePerUnitCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(7));
    }

    public Field68B setComponent7(String string) {
        this.setComponent(7, string);
        return this;
    }

    public Field68B setComponent7(Currency currency) {
        this.setComponent(7, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field68B setPricePerUnitCurrency(String string) {
        this.setComponent(7, string);
        return this;
    }

    public Field68B setPricePerUnitCurrency(Currency currency) {
        this.setComponent(7, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent8() {
        return this.getComponent(8);
    }

    public Number getComponent8AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(8));
    }

    public String getPricePerUnit() {
        return this.getComponent(8);
    }

    public Number getPricePerUnitAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(8));
    }

    public Field68B setComponent8(String string) {
        this.setComponent(8, string);
        return this;
    }

    public Field68B setComponent8(Number number) {
        this.setComponent(8, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field68B setPricePerUnit(String string) {
        this.setComponent(8, string);
        return this;
    }

    public Field68B setPricePerUnit(Number number) {
        this.setComponent(8, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public String getComponent9() {
        return this.getComponent(9);
    }

    public Calendar getComponent9AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(9));
    }

    public String getValueDateOfTheConsideration() {
        return this.getComponent(9);
    }

    public Calendar getValueDateOfTheConsiderationAsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(9));
    }

    public Field68B setComponent9(String string) {
        this.setComponent(9, string);
        return this;
    }

    public Field68B setComponent9(Calendar calendar) {
        this.setComponent(9, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public Field68B setValueDateOfTheConsideration(String string) {
        this.setComponent(9, string);
        return this;
    }

    public Field68B setValueDateOfTheConsideration(Calendar calendar) {
        this.setComponent(9, SwiftFormatUtils.getDate2(calendar));
        return this;
    }

    public String getComponent10() {
        return this.getComponent(10);
    }

    public Currency getComponent10AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(10));
    }

    public String getConsiderationCurrency() {
        return this.getComponent(10);
    }

    public Currency getConsiderationCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(10));
    }

    public Field68B setComponent10(String string) {
        this.setComponent(10, string);
        return this;
    }

    public Field68B setComponent10(Currency currency) {
        this.setComponent(10, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field68B setConsiderationCurrency(String string) {
        this.setComponent(10, string);
        return this;
    }

    public Field68B setConsiderationCurrency(Currency currency) {
        this.setComponent(10, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent11() {
        return this.getComponent(11);
    }

    public Number getComponent11AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(11));
    }

    public String getConsideration() {
        return this.getComponent(11);
    }

    public Number getConsiderationAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(11));
    }

    public Field68B setComponent11(String string) {
        this.setComponent(11, string);
        return this;
    }

    public Field68B setComponent11(Number number) {
        this.setComponent(11, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field68B setConsideration(String string) {
        this.setComponent(11, string);
        return this;
    }

    public Field68B setConsideration(Number number) {
        this.setComponent(11, SwiftFormatUtils.getNumber(number));
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        arrayList.add(SwiftFormatUtils.getDate2(this.getComponent(1)));
        arrayList.add(SwiftFormatUtils.getDate2(this.getComponent(2)));
        arrayList.add(SwiftFormatUtils.getDate2(this.getComponent(9)));
        return arrayList;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "68B";
    }

    public static Field68B get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field68B)swiftTagListBlock.getFieldByName("68B");
    }

    public static Field68B get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field68B.get(swiftMessage.getBlock4());
    }

    public static List<Field68B> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field68B.getAll(swiftMessage.getBlock4());
    }

    public static List<Field68B> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("68B");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field68B> arrayList = new ArrayList<Field68B>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field68B)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

