/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field71L
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "71L";
    public static final String F_71L = "71L";
    public static final String PARSER_PATTERN = "SN";
    public static final String COMPONENTS_PATTERN = "CN";

    public static Tag tag(String string) {
        return new Tag("71L", string);
    }

    public static Tag emptyTag() {
        return new Tag("71L", "");
    }

    public Field71L() {
        super(2);
    }

    public Field71L(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(string));
        this.setComponent2(SwiftParseUtils.getNumericSuffix(string));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.joinComponents());
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Currency getComponent1AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public String getCurrency() {
        return this.getComponent(1);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public Field71L setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field71L setComponent1(Currency currency) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field71L setCurrency(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field71L setCurrency(Currency currency) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getAmount() {
        return this.getComponent(2);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field71L setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field71L setComponent2(Number number) {
        this.setComponent(2, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field71L setAmount(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field71L setAmount(Number number) {
        this.setComponent(2, SwiftFormatUtils.getNumber(number));
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "71L";
    }

    public static Field71L get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field71L)swiftTagListBlock.getFieldByName("71L");
    }

    public static Field71L get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field71L.get(swiftMessage.getBlock4());
    }

    public static List<Field71L> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field71L.getAll(swiftMessage.getBlock4());
    }

    public static List<Field71L> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("71L");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field71L> arrayList = new ArrayList<Field71L>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field71L)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

