/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field89A
extends Field
implements Serializable,
BICContainer {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "89A";
    public static final String F_89A = "89A";
    public static final String PARSER_PATTERN = "[[/c][/S]$]S";
    public static final String COMPONENTS_PATTERN = "SSB";

    public static Tag tag(String string) {
        return new Tag("89A", string);
    }

    public static Tag emptyTag() {
        return new Tag("89A", "");
    }

    public Field89A() {
        super(3);
    }

    public Field89A(String string) {
        this();
        List<String> list = SwiftParseUtils.getLines(string);
        if (list.size() > 0) {
            if (list.get(0).startsWith("/")) {
                if (list.get(0).startsWith("//")) {
                    this.setComponent1("");
                    this.setComponent2(StringUtils.substring((String)list.get(0), (int)2));
                } else {
                    String string2 = SwiftParseUtils.getTokenFirst(list.get(0), "/", "/");
                    if (StringUtils.isNotEmpty((String)string2)) {
                        if (string2.length() == 1) {
                            this.setComponent1(string2);
                            this.setComponent2(SwiftParseUtils.getTokenSecondLast(StringUtils.substring((String)list.get(0), (int)1), "/"));
                        } else {
                            this.setComponent2(StringUtils.substring((String)list.get(0), (int)1));
                        }
                    }
                }
                if (list.size() > 1) {
                    this.setComponent3(list.get(1));
                }
            } else {
                this.setComponent3(list.get(0));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.getComponent1() != null) {
            stringBuilder.append("/" + StringUtils.trimToEmpty((String)this.getComponent1()));
            bl = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent2())) {
            stringBuilder.append("/" + StringUtils.trimToEmpty((String)this.getComponent2()));
            bl = true;
        }
        if (StringUtils.isNotEmpty((String)this.getComponent3())) {
            if (bl) {
                stringBuilder.append("\r\n");
            }
            stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        }
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public Field89A setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field89A setDCMark(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getAccount() {
        String string = this.getComponent(2);
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '/') continue;
                return string.substring(i);
            }
            return "";
        }
        return null;
    }

    public Field89A setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field89A setAccount(String string) {
        this.setComponent(2, string);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BIC getComponent3AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(3));
    }

    public String getBIC() {
        return this.getComponent(3);
    }

    public BIC getBICAsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(3));
    }

    public Field89A setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field89A setComponent3(BIC bIC) {
        this.setComponent(3, SwiftFormatUtils.getBIC(bIC));
        return this;
    }

    public Field89A setBIC(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field89A setBIC(BIC bIC) {
        this.setComponent(3, SwiftFormatUtils.getBIC(bIC));
        return this;
    }

    @Override
    public List<BIC> bics() {
        ArrayList<BIC> arrayList = new ArrayList<BIC>();
        arrayList.add(SwiftFormatUtils.getBIC(this.getComponent(3)));
        return arrayList;
    }

    @Override
    public List<String> bicStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getComponent(3));
        return arrayList;
    }

    @Override
    public boolean isOptional(int n) {
        if (n == 1) {
            return true;
        }
        return n == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "89A";
    }

    public static Field89A get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field89A)swiftTagListBlock.getFieldByName("89A");
    }

    public static Field89A get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field89A.get(swiftMessage.getBlock4());
    }

    public static List<Field89A> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field89A.getAll(swiftMessage.getBlock4());
    }

    public static List<Field89A> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("89A");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field89A> arrayList = new ArrayList<Field89A>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field89A)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

