/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field92B
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer,
GenericField {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "92B";
    public static final String F_92B = "92B";
    public static final String PARSER_PATTERN = ":S//S/S/N";
    public static final String COMPONENTS_PATTERN = "SCCN";

    public static Tag tag(String string) {
        return new Tag("92B", string);
    }

    public static Tag emptyTag() {
        return new Tag("92B", "");
    }

    public Field92B() {
        super(4);
    }

    public Field92B(String string) {
        this();
        this.setComponent1(SwiftParseUtils.getTokenFirst(string, ":", "//"));
        String string2 = SwiftParseUtils.getTokenSecondLast(string, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(string2, "/"));
        this.setComponent3(SwiftParseUtils.getTokenSecond(string2, "/"));
        this.setComponent4(SwiftParseUtils.getTokenThirdLast(string2, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        stringBuilder.append("//");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        return stringBuilder.toString();
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field92B setComponent1(String string) {
        this.setComponent(1, string);
        return this;
    }

    public Field92B setQualifier(String string) {
        this.setComponent(1, string);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getFirstCurrencyCode() {
        return this.getComponent(2);
    }

    public Currency getFirstCurrencyCodeAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public Field92B setComponent2(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field92B setComponent2(Currency currency) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field92B setFirstCurrencyCode(String string) {
        this.setComponent(2, string);
        return this;
    }

    public Field92B setFirstCurrencyCode(Currency currency) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Currency getComponent3AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public String getSecondCurrencyCode() {
        return this.getComponent(3);
    }

    public Currency getSecondCurrencyCodeAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(3));
    }

    public Field92B setComponent3(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field92B setComponent3(Currency currency) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public Field92B setSecondCurrencyCode(String string) {
        this.setComponent(3, string);
        return this;
    }

    public Field92B setSecondCurrencyCode(Currency currency) {
        this.setComponent(3, SwiftFormatUtils.getCurrency(currency));
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getRate() {
        return this.getComponent(4);
    }

    public Number getRateAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field92B setComponent4(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field92B setComponent4(Number number) {
        this.setComponent(4, SwiftFormatUtils.getNumber(number));
        return this;
    }

    public Field92B setRate(String string) {
        this.setComponent(4, string);
        return this;
    }

    public Field92B setRate(Number number) {
        this.setComponent(4, SwiftFormatUtils.getNumber(number));
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        ArrayList<String> arrayList = new ArrayList();
        arrayList = CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
        return arrayList;
    }

    @Override
    public List<Currency> currencies() {
        List<String> list = this.currencyStrings();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (String string : list) {
            arrayList.add(Currency.getInstance(string));
        }
        return arrayList;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String string) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, string);
    }

    @Override
    public void initializeCurrencies(Currency currency) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, currency);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this, new int[0]);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int n) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent2();
    }

    @Override
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "92B";
    }

    public static Field92B get(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        return (Field92B)swiftTagListBlock.getFieldByName("92B");
    }

    public static Field92B get(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field92B.get(swiftMessage.getBlock4());
    }

    public static List<Field92B> getAll(SwiftMessage swiftMessage) {
        if (swiftMessage == null || swiftMessage.getBlock4() == null || swiftMessage.getBlock4().isEmpty()) {
            return null;
        }
        return Field92B.getAll(swiftMessage.getBlock4());
    }

    public static List<Field92B> getAll(SwiftTagListBlock swiftTagListBlock) {
        if (swiftTagListBlock == null || swiftTagListBlock.isEmpty()) {
            return null;
        }
        Field[] fieldArray = swiftTagListBlock.getFieldsByName("92B");
        if (fieldArray != null && fieldArray.length > 0) {
            ArrayList<Field92B> arrayList = new ArrayList<Field92B>(fieldArray.length);
            for (Field field : fieldArray) {
                arrayList.add((Field92B)field);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

