/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.Field;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwiftParseUtils {
    private static final transient Logger log = Logger.getLogger(SwiftParseUtils.class.getName());

    public static List<String> splitComponents(String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)string)) {
            string = SwiftParseUtils.removePrefix(string, string2);
            if (StringUtils.isNotBlank((String)string3)) {
                String[] stringArray = StringUtils.splitByWholeSeparator((String)string, (String)string3);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!StringUtils.isNotBlank((String)stringArray[i])) continue;
                    arrayList.add(stringArray[i]);
                }
            } else {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public static String getTokenFirst(String string, String string2, String string3) {
        String string4 = null;
        if (StringUtils.isNotBlank((String)string) && StringUtils.isBlank((String)(string4 = StringUtils.substringBefore((String)(string = SwiftParseUtils.removePrefix(string, string2)), (String)string3)))) {
            return null;
        }
        return string4;
    }

    public static String getTokenFirst(String string, String string2) {
        return SwiftParseUtils.getTokenFirst(string, null, string2);
    }

    public static String removePrefix(String string, String string2) {
        if (StringUtils.isNotBlank((String)string) && StringUtils.isNotBlank((String)string2) && string.startsWith(string2)) {
            return StringUtils.substringAfter((String)string, (String)string2);
        }
        return string;
    }

    public static String getTokenSecond(String string, String string2) {
        String string3 = SwiftParseUtils.getTokenFirst(StringUtils.substringAfter((String)string, (String)string2), null, string2);
        return string3;
    }

    public static String getTokenSecondLast(String string, String string2) {
        String string3 = StringUtils.substringAfter((String)string, (String)string2);
        if (StringUtils.isBlank((String)string3)) {
            string3 = null;
        }
        return string3;
    }

    public static String getTokenSecond(String string, String string2, String string3) {
        return SwiftParseUtils.getTokenSecond(SwiftParseUtils.removePrefix(string, string2), string3);
    }

    public static String getTokenSecondLast(String string, String string2, String string3) {
        return SwiftParseUtils.getTokenSecondLast(SwiftParseUtils.removePrefix(string, string2), string3);
    }

    public static String getTokenThird(String string, String string2) {
        String string3 = SwiftParseUtils.getTokenSecond(SwiftParseUtils.getTokenSecondLast(string, string2), string2);
        return string3;
    }

    public static String getTokenThirdLast(String string, String string2) {
        String string3 = null;
        String string4 = SwiftParseUtils.getTokenSecondLast(string, string2);
        if (StringUtils.isNotBlank((String)string4) && StringUtils.isBlank((String)(string3 = StringUtils.substringAfter((String)string4, (String)string2)))) {
            string3 = null;
        }
        return string3;
    }

    public static String getTokenForth(String string, String string2) {
        String string3 = SwiftParseUtils.getTokenSecond(SwiftParseUtils.getTokenThirdLast(string, string2), string2);
        return string3;
    }

    public static String getTokenForthLast(String string, String string2) {
        String string3 = null;
        String string4 = SwiftParseUtils.getTokenThirdLast(string, string2);
        if (StringUtils.isNotBlank((String)string4) && StringUtils.isBlank((String)(string3 = StringUtils.substringAfter((String)string4, (String)string2)))) {
            string3 = null;
        }
        return string3;
    }

    public static String getAlphaPrefix(String string) {
        if (string != null && string.length() > 0) {
            int n;
            for (n = 0; n < string.length() && !StringUtils.isNumeric((String)("" + string.charAt(n))); ++n) {
            }
            if (n > 0) {
                return StringUtils.substring((String)string, (int)0, (int)n);
            }
        }
        return null;
    }

    public static String getNumericPrefix(String string) {
        if (string != null && string.length() > 0) {
            int n;
            for (n = 0; n < string.length() && (StringUtils.isNumeric((String)("" + string.charAt(n))) || StringUtils.equals((String)("" + string.charAt(n)), (String)",")); ++n) {
            }
            if (n > 0) {
                return StringUtils.substring((String)string, (int)0, (int)n);
            }
        }
        return null;
    }

    public static String getNumericSuffix(String string) {
        if (string != null && string.length() > 0) {
            int n;
            for (n = 0; n < string.length() && !StringUtils.isNumeric((String)("" + string.charAt(n))); ++n) {
            }
            if (n < string.length()) {
                return StringUtils.substring((String)string, (int)n);
            }
        }
        return null;
    }

    public static String getAlphaSuffix(String string) {
        if (string != null && string.length() > 0) {
            int n;
            for (n = 0; n < string.length() && (StringUtils.isNumeric((String)("" + string.charAt(n))) || StringUtils.equals((String)("" + string.charAt(n)), (String)",")); ++n) {
            }
            if (n < string.length()) {
                return StringUtils.substring((String)string, (int)n);
            }
        }
        return null;
    }

    public static List<String> getLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            try {
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    arrayList.add(string2);
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                throw new UnhandledException((Throwable)iOException);
            }
        }
        return arrayList;
    }

    public static void setComponentsFromLines(Field field, int n, int n2, int n3, List<String> list) {
        for (int i = 0; i < n2; ++i) {
            if (list.size() > n3) {
                field.setComponent(n, list.get(n3));
            }
            ++n;
            ++n3;
        }
    }

    public static void setComponentsFromTokens(Field field, int n, int n2, int n3, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (stringBuilder.length() < n3) {
                stringBuilder.append(c);
                continue;
            }
            if (n <= n2) {
                field.setComponent(n, stringBuilder.toString());
            }
            ++n;
            stringBuilder = new StringBuilder();
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0 && n <= n2) {
            field.setComponent(n, stringBuilder.toString());
        }
    }
}

