/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt5xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field29A;
import com.prowidesoftware.swift.model.field.Field29B;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field31F;
import com.prowidesoftware.swift.model.field.Field35A;
import com.prowidesoftware.swift.model.field.Field35B;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field83C;
import com.prowidesoftware.swift.model.field.Field87A;
import com.prowidesoftware.swift.model.field.Field87D;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT526
extends AbstractMT
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "526";
    private static final transient Logger log = Logger.getLogger(MT526.class.getName());

    public MT526(SwiftMessage swiftMessage) {
        super(swiftMessage);
    }

    public MT526(MtSwiftMessage mtSwiftMessage) {
        super(mtSwiftMessage);
    }

    public MT526() {
        super(526);
    }

    public MT526(int n, String string, String string2) {
        super(526, string, string2);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT526 append(SwiftTagListBlock swiftTagListBlock) {
        super.append(swiftTagListBlock);
        return this;
    }

    @Override
    public MT526 append(Tag ... tagArray) {
        super.append(tagArray);
        return this;
    }

    @Override
    public MT526 append(Field ... fieldArray) {
        super.append(fieldArray);
        return this;
    }

    public Field20 getField20() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("20");
        if (tag == null) {
            log.fine("field 20 not found");
            return null;
        }
        return new Field20(tag.getValue());
    }

    public Field21 getField21() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("21");
        if (tag == null) {
            log.fine("field 21 not found");
            return null;
        }
        return new Field21(tag.getValue());
    }

    public Field23 getField23() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("23");
        if (tag == null) {
            log.fine("field 23 not found");
            return null;
        }
        return new Field23(tag.getValue());
    }

    public Field83C getField83C() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("83C");
        if (tag == null) {
            log.fine("field 83C not found");
            return null;
        }
        return new Field83C(tag.getValue());
    }

    public Field29A getField29A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("29A");
        if (tag == null) {
            log.fine("field 29A not found");
            return null;
        }
        return new Field29A(tag.getValue());
    }

    public Field29B getField29B() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("29B");
        if (tag == null) {
            log.fine("field 29B not found");
            return null;
        }
        return new Field29B(tag.getValue());
    }

    public List<Field35B> getField35B() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("35B");
        ArrayList<Field35B> arrayList = new ArrayList<Field35B>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field35B(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field35A> getField35A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("35A");
        ArrayList<Field35A> arrayList = new ArrayList<Field35A>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field35A(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field30> getField30() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("30");
        ArrayList<Field30> arrayList = new ArrayList<Field30>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field30(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field31F> getField31F() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("31F");
        ArrayList<Field31F> arrayList = new ArrayList<Field31F>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field31F(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field87A> getField87A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("87A");
        ArrayList<Field87A> arrayList = new ArrayList<Field87A>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field87A(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field87D> getField87D() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("87D");
        ArrayList<Field87D> arrayList = new ArrayList<Field87D>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field87D(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field72> getField72() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("72");
        ArrayList<Field72> arrayList = new ArrayList<Field72>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field72(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public SequenceA getSequenceA() {
        if (this.getSwiftMessage() == null) {
            throw new RuntimeException("SwiftMessage is null");
        }
        SwiftBlock4 swiftBlock4 = this.getSwiftMessage().getBlock4();
        if (swiftBlock4 != null && !swiftBlock4.isEmpty()) {
            SwiftTagListBlock swiftTagListBlock = swiftBlock4.getSubBlockDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (log.isLoggable(Level.FINE)) {
                if (swiftTagListBlock == null) {
                    log.fine("content for sequence SequenceA: is null");
                } else {
                    log.fine("content for sequence SequenceA: " + swiftTagListBlock.tagNamesList());
                }
            }
            if (swiftTagListBlock == null) {
                return new SequenceA();
            }
            return new SequenceA(swiftTagListBlock);
        }
        return null;
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_NAME = "35B";

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock swiftTagListBlock) {
            super(swiftTagListBlock.getTags());
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        public static final String[] END = new String[]{"23"};
        public static final String[] TAIL = new String[]{"83C", "29A", "29B"};

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock swiftTagListBlock) {
            super(swiftTagListBlock.getTags());
        }

        public static SequenceA newInstance(Tag ... tagArray) {
            return SequenceA.newInstance(0, 0, tagArray);
        }

        public static SequenceA newInstance(int n, int n2, Tag ... tagArray) {
            SequenceA sequenceA = new SequenceA();
            sequenceA.addTag(new Tag(START[n], ""));
            if (tagArray != null && tagArray.length > 0) {
                for (Tag tag : tagArray) {
                    sequenceA.addTag(tag);
                }
            }
            sequenceA.addTag(new Tag(END[n2], ""));
            return sequenceA;
        }
    }
}

