/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt6xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field26C;
import com.prowidesoftware.swift.model.field.Field27;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field31C;
import com.prowidesoftware.swift.model.field.Field68B;
import com.prowidesoftware.swift.model.field.Field68C;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT609
extends AbstractMT
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "609";
    public static final String FORWARDS = "FORWARDS";
    public static final String OPTIONS = "OPTIONS";
    public static final String SPOTS = "SPOTS";
    private static final transient Logger log = Logger.getLogger(MT609.class.getName());

    public MT609(SwiftMessage swiftMessage) {
        super(swiftMessage);
    }

    public MT609(MtSwiftMessage mtSwiftMessage) {
        super(mtSwiftMessage);
    }

    public MT609() {
        super(609);
    }

    public MT609(int n, String string, String string2) {
        super(609, string, string2);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT609 append(SwiftTagListBlock swiftTagListBlock) {
        super.append(swiftTagListBlock);
        return this;
    }

    @Override
    public MT609 append(Tag ... tagArray) {
        super.append(tagArray);
        return this;
    }

    @Override
    public MT609 append(Field ... fieldArray) {
        super.append(fieldArray);
        return this;
    }

    public Field27 getField27() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("27");
        if (tag == null) {
            log.fine("field 27 not found");
            return null;
        }
        return new Field27(tag.getValue());
    }

    public Field20 getField20() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("20");
        if (tag == null) {
            log.fine("field 20 not found");
            return null;
        }
        return new Field20(tag.getValue());
    }

    public Field31C getField31C() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("31C");
        if (tag == null) {
            log.fine("field 31C not found");
            return null;
        }
        return new Field31C(tag.getValue());
    }

    public Field30 getField30() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("30");
        if (tag == null) {
            log.fine("field 30 not found");
            return null;
        }
        return new Field30(tag.getValue());
    }

    public List<Field23> getField23() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("23");
        ArrayList<Field23> arrayList = new ArrayList<Field23>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field23(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field26C> getField26C() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("26C");
        ArrayList<Field26C> arrayList = new ArrayList<Field26C>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field26C(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field68B> getField68B() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("68B");
        ArrayList<Field68B> arrayList = new ArrayList<Field68B>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field68B(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field68C> getField68C() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("68C");
        ArrayList<Field68C> arrayList = new ArrayList<Field68C>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field68C(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field72> getField72() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("72");
        ArrayList<Field72> arrayList = new ArrayList<Field72>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field72(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Sequence_1> getSequence_1List() {
        if (this.getSwiftMessage() == null) {
            throw new RuntimeException("SwiftMessage is null");
        }
        SwiftBlock4 swiftBlock4 = this.getSwiftMessage().getBlock4();
        if (swiftBlock4 != null && !swiftBlock4.isEmpty()) {
            ArrayList<Sequence_1> arrayList = new ArrayList<Sequence_1>();
            List<SwiftTagListBlock> list = swiftBlock4.getSubBlocksDelimitedWithOptionalTail(Sequence_1.START, Sequence_1.END, Sequence_1.TAIL);
            if (list != null && !list.isEmpty()) {
                for (SwiftTagListBlock swiftTagListBlock : list) {
                    arrayList.add(new Sequence_1(swiftTagListBlock));
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static class Sequence_1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"26C"};
        public static final String[] END = new String[]{"68B", "68C"};
        public static final String[] TAIL = new String[0];

        private Sequence_1() {
            super(new ArrayList<Tag>());
        }

        private Sequence_1(SwiftTagListBlock swiftTagListBlock) {
            super(swiftTagListBlock.getTags());
        }

        public static Sequence_1 newInstance(Tag ... tagArray) {
            return Sequence_1.newInstance(0, 0, tagArray);
        }

        public static Sequence_1 newInstance(int n, int n2, Tag ... tagArray) {
            Sequence_1 sequence_1 = new Sequence_1();
            sequence_1.addTag(new Tag(START[n], ""));
            if (tagArray != null && tagArray.length > 0) {
                for (Tag tag : tagArray) {
                    sequence_1.addTag(tag);
                }
            }
            sequence_1.addTag(new Tag(END[n2], ""));
            return sequence_1;
        }
    }

    public static class Sequence_0
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_NAME = "23";

        private Sequence_0() {
            super(new ArrayList<Tag>());
        }

        private Sequence_0(SwiftTagListBlock swiftTagListBlock) {
            super(swiftTagListBlock.getTags());
        }
    }
}

