/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt8xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field16A;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field26A;
import com.prowidesoftware.swift.model.field.Field28;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field33B;
import com.prowidesoftware.swift.model.field.Field34B;
import com.prowidesoftware.swift.model.field.Field51A;
import com.prowidesoftware.swift.model.field.Field51C;
import com.prowidesoftware.swift.model.field.Field73;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT801
extends AbstractMT
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "801";
    private static final transient Logger log = Logger.getLogger(MT801.class.getName());

    public MT801(SwiftMessage swiftMessage) {
        super(swiftMessage);
    }

    public MT801(MtSwiftMessage mtSwiftMessage) {
        super(mtSwiftMessage);
    }

    public MT801() {
        super(801);
    }

    public MT801(int n, String string, String string2) {
        super(801, string, string2);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT801 append(SwiftTagListBlock swiftTagListBlock) {
        super.append(swiftTagListBlock);
        return this;
    }

    @Override
    public MT801 append(Tag ... tagArray) {
        super.append(tagArray);
        return this;
    }

    @Override
    public MT801 append(Field ... fieldArray) {
        super.append(fieldArray);
        return this;
    }

    public Field20 getField20() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("20");
        if (tag == null) {
            log.fine("field 20 not found");
            return null;
        }
        return new Field20(tag.getValue());
    }

    public Field28 getField28() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("28");
        if (tag == null) {
            log.fine("field 28 not found");
            return null;
        }
        return new Field28(tag.getValue());
    }

    public Field23 getField23() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("23");
        if (tag == null) {
            log.fine("field 23 not found");
            return null;
        }
        return new Field23(tag.getValue());
    }

    public Field30 getField30() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("30");
        if (tag == null) {
            log.fine("field 30 not found");
            return null;
        }
        return new Field30(tag.getValue());
    }

    public Field33B getField33B() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("33B");
        if (tag == null) {
            log.fine("field 33B not found");
            return null;
        }
        return new Field33B(tag.getValue());
    }

    public Field73 getField73() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("73");
        if (tag == null) {
            log.fine("field 73 not found");
            return null;
        }
        return new Field73(tag.getValue());
    }

    public List<Field51A> getField51A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("51A");
        ArrayList<Field51A> arrayList = new ArrayList<Field51A>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field51A(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field51C> getField51C() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("51C");
        ArrayList<Field51C> arrayList = new ArrayList<Field51C>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field51C(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field26A> getField26A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("26A");
        ArrayList<Field26A> arrayList = new ArrayList<Field26A>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field26A(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field34B> getField34B() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("34B");
        ArrayList<Field34B> arrayList = new ArrayList<Field34B>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field34B(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field16A> getField16A() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("16A");
        ArrayList<Field16A> arrayList = new ArrayList<Field16A>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field16A(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Sequence_0> getSequence_0List() {
        if (this.getSwiftMessage() == null) {
            throw new RuntimeException("SwiftMessage is null");
        }
        SwiftBlock4 swiftBlock4 = this.getSwiftMessage().getBlock4();
        if (swiftBlock4 != null && !swiftBlock4.isEmpty()) {
            ArrayList<Sequence_0> arrayList = new ArrayList<Sequence_0>();
            List<SwiftTagListBlock> list = swiftBlock4.getSubBlocksDelimitedWithOptionalTail(Sequence_0.START, Sequence_0.END, Sequence_0.TAIL);
            if (list != null && !list.isEmpty()) {
                for (SwiftTagListBlock swiftTagListBlock : list) {
                    arrayList.add(new Sequence_0(swiftTagListBlock));
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public List<SequenceB> getSequenceBList() {
        if (this.getSwiftMessage() == null) {
            throw new RuntimeException("SwiftMessage is null");
        }
        SwiftBlock4 swiftBlock4 = this.getSwiftMessage().getBlock4();
        if (swiftBlock4 != null && !swiftBlock4.isEmpty()) {
            ArrayList<SequenceB> arrayList = new ArrayList<SequenceB>();
            List<SwiftTagListBlock> list = swiftBlock4.getSubBlocksDelimitedWithOptionalTail(SequenceB.START, SequenceB.END, SequenceB.TAIL);
            if (list != null && !list.isEmpty()) {
                for (SwiftTagListBlock swiftTagListBlock : list) {
                    arrayList.add(new SequenceB(swiftTagListBlock));
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"23"};
        public static final String[] END = new String[]{"33B"};
        public static final String[] TAIL = new String[]{"73"};

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock swiftTagListBlock) {
            super(swiftTagListBlock.getTags());
        }

        public static SequenceB newInstance(Tag ... tagArray) {
            return SequenceB.newInstance(0, 0, tagArray);
        }

        public static SequenceB newInstance(int n, int n2, Tag ... tagArray) {
            SequenceB sequenceB = new SequenceB();
            sequenceB.addTag(new Tag(START[n], ""));
            if (tagArray != null && tagArray.length > 0) {
                for (Tag tag : tagArray) {
                    sequenceB.addTag(tag);
                }
            }
            sequenceB.addTag(new Tag(END[n2], ""));
            return sequenceB;
        }
    }

    public static class Sequence_0
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"51A", "51C"};
        public static final String[] END = new String[]{"16A"};
        public static final String[] TAIL = new String[0];

        private Sequence_0() {
            super(new ArrayList<Tag>());
        }

        private Sequence_0(SwiftTagListBlock swiftTagListBlock) {
            super(swiftTagListBlock.getTags());
        }

        public static Sequence_0 newInstance(Tag ... tagArray) {
            return Sequence_0.newInstance(0, 0, tagArray);
        }

        public static Sequence_0 newInstance(int n, int n2, Tag ... tagArray) {
            Sequence_0 sequence_0 = new Sequence_0();
            sequence_0.addTag(new Tag(START[n], ""));
            if (tagArray != null && tagArray.length > 0) {
                for (Tag tag : tagArray) {
                    sequence_0.addTag(tag);
                }
            }
            sequence_0.addTag(new Tag(END[n2], ""));
            return sequence_0;
        }
    }
}

