/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt9xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field62F;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MT971
extends AbstractMT
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "971";
    private static final transient Logger log = Logger.getLogger(MT971.class.getName());

    public MT971(SwiftMessage swiftMessage) {
        super(swiftMessage);
    }

    public MT971(MtSwiftMessage mtSwiftMessage) {
        super(mtSwiftMessage);
    }

    public MT971() {
        super(971);
    }

    public MT971(int n, String string, String string2) {
        super(971, string, string2);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT971 append(SwiftTagListBlock swiftTagListBlock) {
        super.append(swiftTagListBlock);
        return this;
    }

    @Override
    public MT971 append(Tag ... tagArray) {
        super.append(tagArray);
        return this;
    }

    @Override
    public MT971 append(Field ... fieldArray) {
        super.append(fieldArray);
        return this;
    }

    public Field20 getField20() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return null;
        }
        Tag tag = this.getSwiftMessage().getBlock4().getTagByName("20");
        if (tag == null) {
            log.fine("field 20 not found");
            return null;
        }
        return new Field20(tag.getValue());
    }

    public List<Field25> getField25() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("25");
        ArrayList<Field25> arrayList = new ArrayList<Field25>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field25(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Field62F> getField62F() {
        if (this.getSwiftMessage() == null) {
            throw new IllegalStateException("SwiftMessage was not initialized");
        }
        if (this.getSwiftMessage().getBlock4() == null) {
            log.info("block4 is null");
            return Collections.emptyList();
        }
        Tag[] tagArray = this.getSwiftMessage().getBlock4().getTagsByName("62F");
        ArrayList<Field62F> arrayList = new ArrayList<Field62F>();
        for (int i = 0; i < tagArray.length; ++i) {
            arrayList.add(new Field62F(tagArray[i].getValue()));
        }
        return arrayList;
    }

    public List<Sequence_0> getSequence_0List() {
        if (this.getSwiftMessage() == null) {
            throw new RuntimeException("SwiftMessage is null");
        }
        SwiftBlock4 swiftBlock4 = this.getSwiftMessage().getBlock4();
        if (swiftBlock4 != null && !swiftBlock4.isEmpty()) {
            ArrayList<Sequence_0> arrayList = new ArrayList<Sequence_0>();
            List<SwiftTagListBlock> list = swiftBlock4.getSubBlocksDelimitedWithOptionalTail(Sequence_0.START, Sequence_0.END, Sequence_0.TAIL);
            if (list != null && !list.isEmpty()) {
                for (SwiftTagListBlock swiftTagListBlock : list) {
                    arrayList.add(new Sequence_0(swiftTagListBlock));
                }
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static class Sequence_0
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"25"};
        public static final String[] END = new String[]{"62F"};
        public static final String[] TAIL = new String[0];

        private Sequence_0() {
            super(new ArrayList<Tag>());
        }

        private Sequence_0(SwiftTagListBlock swiftTagListBlock) {
            super(swiftTagListBlock.getTags());
        }

        public static Sequence_0 newInstance(Tag ... tagArray) {
            return Sequence_0.newInstance(0, 0, tagArray);
        }

        public static Sequence_0 newInstance(int n, int n2, Tag ... tagArray) {
            Sequence_0 sequence_0 = new Sequence_0();
            sequence_0.addTag(new Tag(START[n], ""));
            if (tagArray != null && tagArray.length > 0) {
                for (Tag tag : tagArray) {
                    sequence_0.addTag(tag);
                }
            }
            sequence_0.addTag(new Tag(END[n2], ""));
            return sequence_0;
        }
    }
}

