/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.swift.model.SwiftBlock1;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AckMessageComparator
implements Comparator<SwiftMessage> {
    private static final transient Logger log = Logger.getLogger(AckMessageComparator.class.getName());
    private boolean ignoreEolsInMultiline = false;
    private List<String> tagnamesToIgnore = new ArrayList<String>();

    @Override
    public int compare(SwiftMessage swiftMessage, SwiftMessage swiftMessage2) {
        Validate.notNull((Object)swiftMessage);
        Validate.notNull((Object)swiftMessage2);
        boolean bl = this.compareB1(swiftMessage.getBlock1(), swiftMessage2.getBlock1());
        boolean bl2 = this.compareB2(swiftMessage.getBlock2(), swiftMessage2.getBlock2());
        boolean bl3 = this.compareTagListBlock(swiftMessage.getBlock3(), swiftMessage2.getBlock3());
        boolean bl4 = this.compareTagListBlock(swiftMessage.getBlock4(), swiftMessage2.getBlock4());
        log.fine("b1=" + bl + ", b2=" + bl2 + ", b3=" + bl3 + ", b4=" + bl4);
        return bl && bl2 && bl3 && bl4 ? 0 : 1;
    }

    public boolean compareB2(SwiftBlock2 swiftBlock2, SwiftBlock2 swiftBlock22) {
        if (swiftBlock2 == null && swiftBlock22 == null) {
            return true;
        }
        if (swiftBlock2 == null || swiftBlock22 == null) {
            return false;
        }
        if (!swiftBlock2.getClass().equals(swiftBlock22.getClass())) {
            return false;
        }
        return StringUtils.equals((String)swiftBlock2.getMessagePriority(), (String)swiftBlock22.getMessagePriority()) && StringUtils.equals((String)swiftBlock22.getMessageType(), (String)swiftBlock22.getMessageType());
    }

    public boolean compareTagListBlock(SwiftTagListBlock swiftTagListBlock, SwiftTagListBlock swiftTagListBlock2) {
        if (swiftTagListBlock == null && swiftTagListBlock2 == null) {
            return true;
        }
        if (swiftTagListBlock == null || swiftTagListBlock2 == null) {
            return true;
        }
        if (swiftTagListBlock.isEmpty() || swiftTagListBlock2.isEmpty()) {
            return false;
        }
        if (swiftTagListBlock.size() != swiftTagListBlock2.size()) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < swiftTagListBlock.size(); ++i) {
            Tag tag = swiftTagListBlock.getTag(i);
            Tag tag2 = swiftTagListBlock2.getTag(i);
            if (this.tagNameIgnored(tag.getName(), tag2.getName())) {
                log.finer("Tag ignored: " + tag.getName() + " - " + tag2.getName());
                continue;
            }
            if (StringUtils.equals((String)tag.getName(), (String)tag2.getName()) && this.valuesAreEqual(tag.getValue(), tag2.getValue())) continue;
            System.out.println(tag);
            System.out.println(tag2);
            ++n;
        }
        return n <= 0;
    }

    private boolean valuesAreEqual(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        if (this.ignoreEolsInMultiline) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            BufferedReader bufferedReader2 = new BufferedReader(new StringReader(string2));
            try {
                String string3;
                String string4;
                do {
                    if (StringUtils.equals((String)(string4 = bufferedReader.readLine()), (String)(string3 = bufferedReader2.readLine()))) continue;
                    return false;
                } while (string4 != null || string3 != null);
                return true;
            }
            catch (IOException iOException) {
                throw new UnhandledException((Throwable)iOException);
            }
        }
        return StringUtils.equals((String)string, (String)string2);
    }

    private boolean tagNameIgnored(String string, String string2) {
        if (this.tagnamesToIgnore != null && !this.tagnamesToIgnore.isEmpty()) {
            for (String string3 : this.tagnamesToIgnore) {
                if (!StringUtils.equals((String)string3, (String)string) && !StringUtils.equals((String)string3, (String)string2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean compareB1(SwiftBlock1 swiftBlock1, SwiftBlock1 swiftBlock12) {
        if (swiftBlock1 == null && swiftBlock12 == null) {
            return true;
        }
        if (swiftBlock1 == null || swiftBlock12 == null) {
            return false;
        }
        return StringUtils.equals((String)swiftBlock1.getApplicationId(), (String)swiftBlock12.getApplicationId()) && StringUtils.equals((String)swiftBlock1.getLogicalTerminal(), (String)swiftBlock12.getLogicalTerminal()) && StringUtils.equals((String)swiftBlock1.getServiceId(), (String)swiftBlock12.getServiceId());
    }

    public boolean isIgnoreEolsInMultiline() {
        return this.ignoreEolsInMultiline;
    }

    public void setIgnoreEolsInMultiline(boolean bl) {
        this.ignoreEolsInMultiline = bl;
    }

    public List<String> getTagnamesToIgnore() {
        return this.tagnamesToIgnore;
    }

    public void setTagnamesToIgnore(List<String> list) {
        this.tagnamesToIgnore = list;
    }

    public boolean addTagnameToIgnore(String string) {
        return this.tagnamesToIgnore.add(string);
    }
}

