/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.MIR;
import com.prowidesoftware.swift.model.MOR;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;

public class SwiftFormatUtils {
    private static final transient Logger log = Logger.getLogger(SwiftFormatUtils.class.getName());

    public static Calendar getDate2(String string) {
        if (string != null && string.length() == 6) {
            return SwiftFormatUtils.getCalendar(string, "yyMMdd");
        }
        return null;
    }

    public static String getDate2(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "yyMMdd");
    }

    public static Calendar getDate1(String string) {
        if (string != null && string.length() == 4) {
            return SwiftFormatUtils.getCalendar(string, "MMdd");
        }
        return null;
    }

    public static String getDate1(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "MMdd");
    }

    public static Calendar getDate3(String string) {
        if (string != null && string.length() == 4) {
            return SwiftFormatUtils.getCalendar(string, "yyMM");
        }
        return null;
    }

    public static String getDate3(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "yyMM");
    }

    public static Calendar getDate4(String string) {
        if (string != null && string.length() == 8) {
            return SwiftFormatUtils.getCalendar(string, "yyyyMMdd");
        }
        return null;
    }

    public static String getDate4(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "yyyyMMdd");
    }

    public static Calendar getYear(String string) {
        if (string != null && string.length() == 4) {
            return SwiftFormatUtils.getCalendar(string, "yyyy");
        }
        return null;
    }

    public static String getYear(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "yyyy");
    }

    public static Number getNumber(String string) {
        Number number = null;
        if (string != null) {
            try {
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
                decimalFormatSymbols.setDecimalSeparator(',');
                DecimalFormat decimalFormat = new DecimalFormat("00.##", decimalFormatSymbols);
                decimalFormat.setParseBigDecimal(true);
                number = decimalFormat.parse(string);
            }
            catch (ParseException parseException) {
                log.log(Level.WARNING, "Error parsing number", parseException);
            }
        }
        return number;
    }

    public static String getNumber(Number number) {
        if (number != null) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator(',');
            DecimalFormat decimalFormat = new DecimalFormat("0.##########", decimalFormatSymbols);
            decimalFormat.setParseBigDecimal(true);
            decimalFormat.setDecimalSeparatorAlwaysShown(true);
            String string = decimalFormat.format(number);
            String string2 = StringUtils.replaceChars((String)string, (char)'.', (char)',');
            return string2;
        }
        return null;
    }

    public static Calendar getHhmm(String string) {
        if (string != null && string.length() == 4) {
            return SwiftFormatUtils.getCalendar(string, "HHmm");
        }
        return null;
    }

    private static Calendar getCalendar(String string, String string2) {
        if (string != null) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                simpleDateFormat.setLenient(false);
                Date date = simpleDateFormat.parse(string);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                return gregorianCalendar;
            }
            catch (ParseException parseException) {
                log.log(Level.WARNING, "Could not parse '" + string + "' with pattern '" + string2 + "'");
            }
        }
        return null;
    }

    private static String getCalendar(Calendar calendar, String string) {
        if (calendar != null) {
            return DateFormatUtils.format((Date)calendar.getTime(), (String)string);
        }
        return null;
    }

    public static Calendar getTime2(String string) {
        if (string != null && string.length() == 6) {
            return SwiftFormatUtils.getCalendar(string, "HHmmss");
        }
        return null;
    }

    public static String getTime2(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "HHmmss");
    }

    public static Calendar getTime3(String string) {
        if (string != null) {
            if (string.length() == 2) {
                return SwiftFormatUtils.getCalendar(string, "HH");
            }
            if (string.length() == 4) {
                return SwiftFormatUtils.getCalendar(string, "HHmm");
            }
        }
        return null;
    }

    public static String getTime3(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "HHmm");
    }

    public static Character getSign(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            return Character.valueOf(string.charAt(0));
        }
        return null;
    }

    public static Calendar getOffset(String string) {
        Calendar calendar = SwiftFormatUtils.getHhmm(string);
        return calendar;
    }

    public static String getOffset(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "HHmm");
    }

    public static Currency getCurrency(String string) {
        return Currency.getInstance(string);
    }

    public static String getCurrency(Currency currency) {
        return currency.getCurrencyCode();
    }

    public static BIC getBIC(String string) {
        return new BIC(string);
    }

    public static String getBIC(BIC bIC) {
        return bIC.getBic();
    }

    public static Boolean getBoolean(String string) {
        if (StringUtils.equals((String)"Y", (String)string)) {
            return Boolean.TRUE;
        }
        if (StringUtils.equals((String)"N", (String)string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static String getBoolean(Boolean bl) {
        if (bl == null) {
            return null;
        }
        return bl != false ? "Y" : "N";
    }

    public static Calendar getDateTime(String string) {
        if (string != null && string.length() == 12) {
            return SwiftFormatUtils.getCalendar(string, "yyyyMMddHHmm");
        }
        return null;
    }

    public static String getDateTime(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "yyyyMMddHHmm");
    }

    public static Calendar getDateTimeShortYear(String string) {
        if (string != null && string.length() == 10) {
            return SwiftFormatUtils.getCalendar(string, "yyMMddHHmm");
        }
        return null;
    }

    public static String getDateTimeShortYear(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "yyMMddHHmm");
    }

    public static Calendar getDayTime(String string) {
        if (string != null && string.length() == 6) {
            return SwiftFormatUtils.getCalendar(string, "ddHHmm");
        }
        return null;
    }

    public static String getDayTime(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "ddHHmm");
    }

    public static Calendar getMonthDay(String string) {
        if (string != null && string.length() == 4) {
            return SwiftFormatUtils.getCalendar(string, "MMdd");
        }
        return null;
    }

    public static String getMonthDay(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "MMdd");
    }

    public static Calendar getHour(String string) {
        if (string != null && string.length() == 2) {
            return SwiftFormatUtils.getCalendar(string, "HH");
        }
        return null;
    }

    public static String getHour(Calendar calendar) {
        return SwiftFormatUtils.getCalendar(calendar, "HH");
    }

    public static MIR getMIR(String string) {
        if (string != null && string.length() == 28) {
            return new MIR(string);
        }
        return null;
    }

    public static String getMIR(MIR mIR) {
        if (mIR != null) {
            return mIR.getMIR();
        }
        return null;
    }

    public static MOR getMOR(String string) {
        if (string != null && string.length() == 28) {
            return new MOR(string);
        }
        return null;
    }

    public static String getMOR(MOR mOR) {
        if (mOR != null) {
            return mOR.getMOR();
        }
        return null;
    }

    public static boolean isCurrency(String string) {
        if (StringUtils.isNotBlank((String)string)) {
            try {
                return Currency.getInstance(string) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

