/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.LogicalTerminalAddress;
import com.prowidesoftware.swift.model.SwiftBlock2;
import com.prowidesoftware.swift.model.SwiftBlock2InputField;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.Validate;

public class SwiftBlock2Input
extends SwiftBlock2
implements Serializable {
    private static final transient Logger log = Logger.getLogger(SwiftBlock2.class.getName());
    private static final long serialVersionUID = 6094810199379196198L;
    private String receiverAddress;
    private String deliveryMonitoring;
    private String obsolescencePeriod;

    public SwiftBlock2Input(String messageType, String receiverAddress, String messagePriority, String deliveryMonitoring, String obsolescencePeriod) {
        this.messageType = messageType;
        this.receiverAddress = receiverAddress;
        this.messagePriority = messagePriority;
        this.deliveryMonitoring = deliveryMonitoring;
        this.obsolescencePeriod = obsolescencePeriod;
    }

    public SwiftBlock2Input(String value) {
        this(value, false);
    }

    public SwiftBlock2Input(String value, boolean lenient) {
        this.setValue(value, lenient);
    }

    public SwiftBlock2Input() {
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setReceiverAddress(String receiverAddress) {
        this.receiverAddress = receiverAddress;
    }

    public void setReceiverAddress(LogicalTerminalAddress logicalTerminal) {
        this.receiverAddress = logicalTerminal.getReceiverLogicalTerminalAddress();
    }

    public void setReceiver(BIC bic) {
        this.setReceiverAddress(new LogicalTerminalAddress(bic.getBic11()));
    }

    public void setReceiver(String receiver) {
        this.setReceiverAddress(new LogicalTerminalAddress(receiver));
    }

    public String getReceiverAddress() {
        return this.receiverAddress;
    }

    public BIC getReceiverBIC() {
        return new BIC(this.receiverAddress);
    }

    public void setMessagePriority(String messagePriority) {
        this.messagePriority = messagePriority;
    }

    public String getMessagePriority() {
        return this.messagePriority;
    }

    public void setDeliveryMonitoring(String deliveryMonitoring) {
        this.deliveryMonitoring = deliveryMonitoring;
    }

    public String getDeliveryMonitoring() {
        return this.deliveryMonitoring;
    }

    public DeliveryMonitoring getDeliveryMonitoringType() {
        if (this.deliveryMonitoring != null) {
            try {
                return DeliveryMonitoring.valueOf("_" + this.deliveryMonitoring);
            }
            catch (Exception e) {
                String text = "Block2 deliveryMonitoring contains an invalid value [" + this.deliveryMonitoring + "]";
                log.warning(text);
                log.log(Level.FINEST, text, e);
            }
        }
        return null;
    }

    public void setObsolescencePeriod(String obsolescencePeriod) {
        this.obsolescencePeriod = obsolescencePeriod;
    }

    public String getObsolescencePeriod() {
        return this.obsolescencePeriod;
    }

    public boolean isEmpty() {
        return this.messageType == null && this.receiverAddress == null && this.messagePriority == null && this.deliveryMonitoring == null && this.obsolescencePeriod == null;
    }

    public String getValue() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuilder v = new StringBuilder("I");
        if (this.messageType != null) {
            v.append(this.messageType);
        }
        if (this.receiverAddress != null) {
            v.append(this.receiverAddress);
        }
        if (this.messagePriority != null) {
            v.append(this.messagePriority);
        }
        if (this.deliveryMonitoring != null) {
            v.append(this.deliveryMonitoring);
        }
        if (this.obsolescencePeriod != null) {
            v.append(this.obsolescencePeriod);
        }
        return v.toString();
    }

    public String getBlockValue() {
        return this.getValue();
    }

    public void setValue(String value) {
        this.setValue(value, false);
    }

    public void setValue(String value, boolean lenient) {
        if (lenient) {
            this.clean();
        } else {
            Validate.notNull((Object)value, (String)"value must not be null");
        }
        if (value != null) {
            int slen = value.length();
            if (!lenient) {
                Validate.notNull((Object)value, (String)"value must not be null");
                Validate.isTrue((slen >= 16 && slen <= 23 ? 1 : 0) != 0, (String)("expected a string value of 17 up to 23 chars and obtained a " + slen + " chars string: '" + value + "'"));
            }
            int offset = 0;
            if (value.startsWith("2:")) {
                offset = 2;
            }
            slen -= offset;
            if (!lenient) {
                if (slen != 16 && slen != 17 && slen != 18 && slen != 21) {
                    throw new IllegalArgumentException("Value must match: I<mt><address>[<pri>[<monitoring>[<obsolescence>]]]");
                }
                if (Character.toUpperCase(value.charAt(offset)) != 'I') {
                    throw new IllegalArgumentException("Value must match: I<mt><address>[<pri>[<monitoring>[<obsolescence>]]]");
                }
            }
            int len = 3;
            this.setMessageType(this.getValuePart(value, ++offset, len));
            offset += len;
            len = 12;
            this.setReceiverAddress(this.getValuePart(value, offset, len));
            offset += len;
            len = 1;
            this.setMessagePriority(this.getValuePart(value, offset, len));
            offset += len;
            len = 1;
            this.setDeliveryMonitoring(this.getValuePart(value, offset, len));
            offset += len;
            if (lenient) {
                this.setObsolescencePeriod(this.getValuePart(value, offset));
            } else {
                len = 3;
                this.setObsolescencePeriod(this.getValuePart(value, offset, len));
            }
        }
    }

    public void setBlockValue(String value) {
        this.setValue(value);
    }

    public void clean() {
        this.messagePriority = null;
        this.messageType = null;
        this.receiverAddress = null;
        this.deliveryMonitoring = null;
        this.obsolescencePeriod = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.deliveryMonitoring == null ? 0 : this.deliveryMonitoring.hashCode());
        result = 31 * result + (this.messagePriority == null ? 0 : this.messagePriority.hashCode());
        result = 31 * result + (this.messageType == null ? 0 : this.messageType.hashCode());
        result = 31 * result + (this.obsolescencePeriod == null ? 0 : this.obsolescencePeriod.hashCode());
        result = 31 * result + (this.receiverAddress == null ? 0 : this.receiverAddress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwiftBlock2Input other = (SwiftBlock2Input)obj;
        if (this.deliveryMonitoring == null ? other.deliveryMonitoring != null : !this.deliveryMonitoring.equals(other.deliveryMonitoring)) {
            return false;
        }
        if (this.messagePriority == null ? other.messagePriority != null : !this.messagePriority.equals(other.messagePriority)) {
            return false;
        }
        if (this.messageType == null ? other.messageType != null : !this.messageType.equals(other.messageType)) {
            return false;
        }
        if (this.obsolescencePeriod == null ? other.obsolescencePeriod != null : !this.obsolescencePeriod.equals(other.obsolescencePeriod)) {
            return false;
        }
        return !(this.receiverAddress == null ? other.receiverAddress != null : !this.receiverAddress.equals(other.receiverAddress));
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ \n");
        sb.append(" \"messageType\" : \"").append(this.messageType).append("\", \n");
        sb.append(" \"receiverAddress\" : \"").append(this.receiverAddress).append("\", \n");
        sb.append(" \"messagePriority\" : \"").append(this.messagePriority).append("\", \n");
        sb.append(" \"deliveryMonitoring\" : \"").append(this.deliveryMonitoring).append("\", \n");
        sb.append(" \"obsolescencePeriod\" : \"").append(this.obsolescencePeriod).append("\" \n");
        sb.append("} ");
        return sb.toString();
    }

    public String field(SwiftBlock2InputField field) {
        switch (field) {
            case MessageType: {
                return this.getMessageType();
            }
            case MessagePriority: {
                return this.getMessagePriority();
            }
            case ReceiverAddress: {
                return this.getReceiverAddress();
            }
            case DeliveryMonitoring: {
                return this.getDeliveryMonitoring();
            }
            case ObsolescencePeriod: {
                return this.getObsolescencePeriod();
            }
        }
        return null;
    }

    public void setField(SwiftBlock2InputField field, String value) {
        switch (field) {
            case MessageType: {
                this.setMessageType(value);
                break;
            }
            case MessagePriority: {
                this.setMessagePriority(value);
                break;
            }
            case ReceiverAddress: {
                this.setReceiverAddress(value);
                break;
            }
            case DeliveryMonitoring: {
                this.setDeliveryMonitoring(value);
                break;
            }
            case ObsolescencePeriod: {
                this.setObsolescencePeriod(value);
                break;
            }
            default: {
                log.warning("don't know how to set " + (Object)((Object)field) + " to block2");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeliveryMonitoring {
        _1("Non-Delivery Warning"),
        _2("Delivery Notification"),
        _3("Non-Delivery Warning and Delivery Notification");

        private String label;

        private DeliveryMonitoring(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

