/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field13C
extends Field
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "13C";
    public static final String F_13C = "13C";
    public static final String PARSER_PATTERN = "/S/<HHMM><SIGN><OFFSET>";
    public static final String COMPONENTS_PATTERN = "SHGO";
    public static final Integer CODE = 1;
    public static final Integer TIME = 2;
    public static final Integer SIGN = 3;
    public static final Integer OFFSET = 4;

    public Field13C() {
        super(4);
    }

    public Field13C(String value) {
        super(value);
    }

    public Field13C(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"13C")) {
            throw new IllegalArgumentException("cannot create field 13C from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/", "/"));
        String toparse = SwiftParseUtils.getTokenSecondLast(SwiftParseUtils.removePrefix(value, "/"), "/");
        if (toparse != null) {
            if (toparse.length() >= 4) {
                this.setComponent2(StringUtils.substring((String)toparse, (int)0, (int)4));
            }
            if (toparse.length() >= 5) {
                this.setComponent3(StringUtils.substring((String)toparse, (int)4, (int)5));
            }
            if (toparse.length() > 5) {
                this.setComponent4(StringUtils.substring((String)toparse, (int)5));
            }
        }
    }

    public static Field13C newInstance(Field13C source) {
        Field13C cp = new Field13C();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("13C", value);
    }

    public static Tag emptyTag() {
        return new Tag("13C", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getCode() {
        return this.getComponent(1);
    }

    public Field13C setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field13C setCode(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(2));
    }

    public String getTime() {
        return this.getComponent(2);
    }

    public Calendar getTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(2));
    }

    public Field13C setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field13C setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getTime3(component2));
        return this;
    }

    public Field13C setTime(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field13C setTime(Calendar component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getSign() {
        return this.getComponent(3);
    }

    public Field13C setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field13C setSign(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getOffset(this.getComponent(4));
    }

    public String getOffset() {
        return this.getComponent(4);
    }

    public Calendar getOffsetAsCalendar() {
        return SwiftFormatUtils.getOffset(this.getComponent(4));
    }

    public Field13C setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field13C setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getOffset(component4));
        return this;
    }

    public Field13C setOffset(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field13C setOffset(Calendar component4) {
        this.setComponent4(component4);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "13C";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "/8c/<HHMM><SIGN><OFFSET>";
    }

    public static Field13C get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("13C");
        if (t == null) {
            return null;
        }
        return new Field13C(t);
    }

    public static Field13C get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field13C.get(msg.getBlock4());
    }

    public static List<Field13C> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field13C.getAll(msg.getBlock4());
    }

    public static List<Field13C> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("13C");
        if (arr != null && arr.length > 0) {
            ArrayList<Field13C> result = new ArrayList<Field13C>(arr.length);
            for (Tag f : arr) {
                result.add(new Field13C(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 13C");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            SimpleDateFormat f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Code");
        result.add("Time");
        result.add("Sign");
        result.add("Offset");
        return result;
    }
}

