/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field14S
extends Field
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "14S";
    public static final String F_14S = "14S";
    public static final String PARSER_PATTERN = "SN[/<HHMM>/S]";
    public static final String COMPONENTS_PATTERN = "SNHS";
    public static final Integer SOURCE = 1;
    public static final Integer NUMBER = 2;
    public static final Integer TIME = 3;

    public Field14S() {
        super(4);
    }

    public Field14S(String value) {
        super(value);
    }

    public Field14S(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"14S")) {
            throw new IllegalArgumentException("cannot create field 14S from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(4);
        if (value != null) {
            String left;
            String right = null;
            if (value.indexOf(47) >= 0) {
                left = SwiftParseUtils.getTokenFirst(value, "/");
                right = SwiftParseUtils.getTokenSecondLast(value, "/");
            } else {
                left = value;
            }
            this.setComponent1(SwiftParseUtils.getAlphaPrefix(left));
            String second = this.getComponent1() == null ? left : StringUtils.substringAfter((String)left, (String)this.getComponent1());
            this.setComponent2(second);
            if (right != null) {
                this.setComponent3(SwiftParseUtils.getTokenFirst(right, "/"));
                this.setComponent4(SwiftParseUtils.getTokenSecondLast(right, "/"));
            }
        }
    }

    public static Field14S newInstance(Field14S source) {
        Field14S cp = new Field14S();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        if (StringUtils.isNotEmpty((String)this.getComponent3()) || StringUtils.isNotEmpty((String)this.getComponent4())) {
            result.append("/");
            result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
            result.append("/");
            result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("14S", value);
    }

    public static Tag emptyTag() {
        return new Tag("14S", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getSource() {
        return this.getComponent(1);
    }

    public Field14S setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field14S setSource(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Number getComponent2AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public String getNumber() {
        return this.getComponent(2);
    }

    public Number getNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(2));
    }

    public Field14S setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field14S setComponent2(Number component2) {
        if (component2 != null) {
            this.setComponent(2, Integer.toString(component2.intValue()));
        }
        return this;
    }

    public Field14S setNumber(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field14S setNumber(Number component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public String getTime() {
        return this.getComponent(3);
    }

    public Calendar getTimeAsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public Field14S setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field14S setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime3(component3));
        return this;
    }

    public Field14S setTime(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field14S setTime(Calendar component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        return this.getComponent(4);
    }

    public Field14S setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 3) {
            return true;
        }
        return component == 4;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "14S";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "3!a2!n[/<HHMM>/4!c]";
    }

    public static Field14S get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("14S");
        if (t == null) {
            return null;
        }
        return new Field14S(t);
    }

    public static Field14S get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field14S.get(msg.getBlock4());
    }

    public static List<Field14S> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field14S.getAll(msg.getBlock4());
    }

    public static List<Field14S> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("14S");
        if (arr != null && arr.length > 0) {
            ArrayList<Field14S> result = new ArrayList<Field14S>(arr.length);
            for (Tag f : arr) {
                result.add(new Field14S(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Format f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 14S");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            Number n = this.getComponent2AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 3) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            Calendar cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Source");
        result.add("Number");
        result.add("Time");
        result.add(null);
        return result;
    }
}

