/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field26C
extends Field
implements Serializable {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "26C";
    public static final String F_26C = "26C";
    public static final String PARSER_PATTERN = "[S]/S/5!a4!aS";
    public static final String COMPONENTS_PATTERN = "SSSSS";

    public Field26C() {
        super(5);
    }

    public Field26C(String value) {
        super(value);
    }

    public Field26C(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"26C")) {
            throw new IllegalArgumentException("cannot create field 26C from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, null, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
        String toparse = SwiftParseUtils.getTokenThirdLast(value, "/");
        if (toparse != null) {
            if (toparse.length() < 5) {
                this.setComponent3(toparse);
            }
            if (toparse.length() >= 5) {
                this.setComponent3(StringUtils.substring((String)toparse, (int)0, (int)5));
            }
            if (toparse.length() > 5 && toparse.length() < 9) {
                this.setComponent4(StringUtils.substring((String)toparse, (int)5));
            }
            if (toparse.length() >= 9) {
                this.setComponent4(StringUtils.substring((String)toparse, (int)5, (int)9));
            }
            if (toparse.length() > 9) {
                this.setComponent5(StringUtils.substring((String)toparse, (int)9));
            }
        }
    }

    public static Field26C newInstance(Field26C source) {
        Field26C cp = new Field26C();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        result.append("/");
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent4()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent5()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("26C", value);
    }

    public static Tag emptyTag() {
        return new Tag("26C", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public Field26C setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public Field26C setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public Field26C setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        return this.getComponent(4);
    }

    public Field26C setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public Field26C setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        return component == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "26C";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "[3!a]/15x/5!a4!a<VAR-SEQU-4>";
    }

    public static Field26C get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("26C");
        if (t == null) {
            return null;
        }
        return new Field26C(t);
    }

    public static Field26C get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field26C.get(msg.getBlock4());
    }

    public static List<Field26C> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field26C.getAll(msg.getBlock4());
    }

    public static List<Field26C> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("26C");
        if (arr != null && arr.length > 0) {
            ArrayList<Field26C> result = new ArrayList<Field26C>(arr.length);
            for (Tag f : arr) {
                result.add(new Field26C(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 26C");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(null);
        result.add(null);
        result.add(null);
        result.add(null);
        result.add(null);
        return result;
    }
}

