/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field32R
extends Field
implements Serializable,
AmountContainer {
    public static final int SRU = 2016;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "32R";
    public static final String F_32R = "32R";
    public static final String PARSER_PATTERN = "[c]SN";
    public static final String COMPONENTS_PATTERN = "SSN";
    public static final Integer SIGN = 1;
    public static final Integer AMOUNT = 3;

    public Field32R() {
        super(3);
    }

    public Field32R(String value) {
        super(value);
    }

    public Field32R(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"32R")) {
            throw new IllegalArgumentException("cannot create field 32R from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        String prefix = SwiftParseUtils.getAlphaPrefix(value);
        if (prefix != null) {
            if (prefix.length() > 3) {
                this.setComponent1(StringUtils.substring((String)prefix, (int)0, (int)1));
                this.setComponent2(StringUtils.substring((String)prefix, (int)1, (int)prefix.length()));
            } else {
                this.setComponent2(prefix);
            }
        }
        this.setComponent3(SwiftParseUtils.getNumericSuffix(value));
    }

    public static Field32R newInstance(Field32R source) {
        Field32R cp = new Field32R();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotEmpty((String)this.getComponent1())) {
            result.append(StringUtils.trimToEmpty((String)this.getComponent1()));
        }
        result.append(StringUtils.trimToEmpty((String)this.getComponent2()));
        result.append(StringUtils.trimToEmpty((String)this.getComponent3()));
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("32R", value);
    }

    public static Tag emptyTag() {
        return new Tag("32R", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getSign() {
        return this.getComponent(1);
    }

    public Field32R setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field32R setSign(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public Field32R setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getAmount() {
        return this.getComponent(3);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field32R setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field32R setComponent3(Number component3) {
        this.setComponent(3, SwiftFormatUtils.getNumber(component3));
        return this;
    }

    public Field32R setAmount(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field32R setAmount(Number component3) {
        this.setComponent3(component3);
        return this;
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return component == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "32R";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "[<N>]3!a<AMOUNT>15";
    }

    public static Field32R get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("32R");
        if (t == null) {
            return null;
        }
        return new Field32R(t);
    }

    public static Field32R get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field32R.get(msg.getBlock4());
    }

    public static List<Field32R> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field32R.getAll(msg.getBlock4());
    }

    public static List<Field32R> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("32R");
        if (arr != null && arr.length > 0) {
            ArrayList<Field32R> result = new ArrayList<Field32R>(arr.length);
            for (Tag f : arr) {
                result.add(new Field32R(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 32R");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            Number n = this.getComponent3AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Sign");
        result.add(null);
        result.add("Amount");
        return result;
    }
}

